/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SSTV_CALLBACKS_H
#define SSTV_CALLBACKS_H   1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

/* callbacks.c */
void on_sstv_window_destroy(GObject *object, gpointer user_data);
gboolean on_sstv_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_sstv_rx_image_window_destroy(GObject *object, gpointer user_data);
gboolean on_sstv_rx_image_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_sstv_tx_image_window_destroy(GObject *object, gpointer user_data);
gboolean on_sstv_tx_image_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_sstv_tx_image_key_press(GtkWidget *widget, GdkEventKey *event, gpointer user_data);
gboolean on_sstv_tx_image_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
gboolean on_sstv_tx_image_motion_notify(GtkWidget *widget, GdkEventMotion *event, gpointer user_data);
void on_sstv_tx_image_type_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_sstv_tx_image_draw_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_sstv_tx_image_gallery_clicked(GtkButton *button, gpointer user_data);
void on_sstv_tx_pick_color_set(GtkColorButton *button, gpointer user_data);
void on_sstv_tx_font_chooser_font_activated(GtkFontChooser *self, const char *fontname, gpointer user_data);
void on_sstv_tx_font_chooser_font_set(GtkFontButton *widget, gpointer user_data);
void on_sstv_tx_font_capitals_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_sstv_tx_brush_size_value_changed(GtkSpinButton *spinbutton, gpointer user_data);
void on_sstv_gallery_window_destroy(GObject *object, gpointer user_data);
gboolean on_sstv_gallery_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_sstv_gallery_item_activated(GtkIconView *iconview, GtkTreePath *path, gpointer user_data);
void on_sstv_scope_drawingarea_configure(GtkWidget *widget, GdkEventConfigure *event, gpointer user_data);
gboolean on_sstv_scope_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_sstv_spectrum_drawingarea_configure(GtkWidget *widget, const GdkEventConfigure *event, gpointer user_data);
gboolean on_sstv_spectrum_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_sstv_rx_image_drawingarea_configure(GtkWidget *widget, const GdkEventConfigure *event, gpointer user_data);
gboolean on_sstv_rx_image_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_sstv_receive_button_clicked(GtkButton *button, gpointer user_data);
void on_sstv_transmit_button_clicked(GtkButton *button, gpointer user_data);
void on_sstv_modes_button_clicked(GtkButton *button, gpointer user_data);
void on_sstv_mode_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_sstv_save_image_button_clicked(GtkButton *button, gpointer user_data);
void on_sstv_listen_button_clicked(GtkButton *button, gpointer user_data);
void on_sstv_auto_listen_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_sstv_autosave_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_sstv_tx_fsk_id_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_sstv_tx_cw_id_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_sstv_sensitivity_hscale_value_changed(GtkRange *range, gpointer user_data);
void on_sstv_callsign_changed(GtkEditable *editable, gpointer user_data);
void on_sstv_rst_out_changed(GtkEditable *editable, gpointer user_data);
void on_sstv_rst_in_changed(GtkEditable *editable, gpointer user_data);
void on_sstv_op_name_changed(GtkEditable *editable, gpointer user_data);
void on_sstv_qth_name_changed(GtkEditable *editable, gpointer user_data);
void on_sstv_locator_changed(GtkEditable *editable, gpointer user_data);
void on_sstv_band_changed(GtkEditable *editable, gpointer user_data);
void on_sstv_new_record_clicked(GtkButton *button, gpointer user_data);
void on_sstv_save_record_clicked(GtkButton *button, gpointer user_data);
void on_sstv_clear_fields_clicked(GtkButton *button, gpointer user_data);

#endif

