/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SSTV_CALLBACK_FUNC_H
#define SSTV_CALLBACK_FUNC_H   1

#include "../common/common.h"
#include <gtk/gtk.h>
#include <stdint.h>

// Mode selected manually
#define MANUAL_SELECT   0xFF

void Sstv_Receive_Button_Clicked(void);
void Sstv_Stop_Transmit(void);
void Sstv_Transmit_Button_Clicked(void);
void Sstv_New_Image(void);
void Sstv_Mode_Menu_Item_Activate(GtkMenuItem *menuitem, uint8_t mode_num);
void Sstv_Rx_Image_Drawingarea_Configure(uint16_t width, uint16_t height);
void Sstv_Tx_Get_Font_Brush_Color(GtkColorButton *button);
void Sstv_Tx_Image_Key_Press(GdkEventKey *event);
void Sstv_Tx_Image_Button_Press(const GdkEventButton *event);
void Sstv_Tx_Image_Gallery_Clicked(void);
void Sstv_Tx_Image_Motion_Notify(GtkWidget *widget, GdkEventMotion *event);
void Sstv_Icon_View_Item_Activate(GtkIconView *iconview, GtkTreePath *path);

#endif

