/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef RTTY_SHARED_H
#define RTTY_SHARED_H   1

#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>
#include <stdint.h>

//------------------------------------------------------------------------

// Configuration parameters structure
typedef struct _RTTY_RC
{
  char font[32];  // Font to use in text views

  uint32_t
    tx_rtty_bit,        // Length of an RTTY element (bit) in DSP samples
    tx_tone_dur,        // Preamble tone duration in secs
    tx_stop_bit_len;    // Tx length of stop bit in DSP samples

  uint16_t
    rx_rtty_bit,        // Length of an RTTY element (bit) in DSP samples
    rx_rtty_2bit,       // Length * 2 of an RTTY element (bit) in DSP samples
    rx_rtty_bit4,       // Length/4 of an RTTY element (bit) in DSP samples
    afsk_shift,         // Mark/Space frequency shift in Hz
    mark_freq,          // AFSK mark frequency
    space_freq,         // AFSK space frequency
    tone_freq;          // Selected Receiver BFO tone frequency

  uint8_t
    sqlch_thr,          // Squelch threshold
    word_wrap,          // Word wrap column number
    ifft_stride,        // IFFT stride over input data (dsp samples)
    samples_per_char;   // Total signal samples per RTTY character

  double
    stop_bit,   // Stop Bit duration (1.0, 1.5 or 2.0 bits)
    mark_dW,    // Phase increment for mark signal phase angle
    space_dW,   // Phase increment for space signal phase angle
    baud_rate;  // Baud Rate for transmission and reception

  char
    rc_fpath[FILE_NAME_SIZE],    // Rtty runtime config file path
    rtty_glade[FILE_NAME_SIZE];  // Rtty builder's glade file

} rtty_rc_t;

// Runtime config data
extern rtty_rc_t rtty_rc;

//-------------------------------------------------------------------

// RTTY GUI widgets
typedef struct _RTTY_GUI
{
  GtkWidget
    *window,
    *rtty_scope,
    *scope_label,
    *shift_label,
    *xmit_status,
    *rcve_status,
    *popup_menu;

  // Main window and menu builders
  GtkBuilder *window_builder, *popup_menu_builder;

  // Text viewers
  GtkTextView *rx_text_view, *tx_text_view;

  // Text buffers for text viewers
  GtkTextBuffer *rx_text_buffer, *tx_text_buffer;
  GtkTextIter tx_text_buffer_iter, rx_text_buffer_iter;

  uint16_t rtty_scope_width, rtty_scope_height;

} rtty_gui_t;

extern rtty_gui_t rtty_gui;

// RTTY waterfall
extern pixbuffer_t rtty_wfall;

// IFFT() data object
extern ifft_data_t rtty_ifft_data;

// Macros attached to F1-F10
extern char *rtty_macro[NUM_OF_LABELS];

//------------------------------------------------------------------------

#endif

