/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "interface.h"
#include "shared.h"
#include "utils.h"
#include "../common/common.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include <gtk/gtk.h>
#include <stdint.h>
#include <stdlib.h>

#define RTTY_POPUP_MENU_IDS \
  "rtty_popup_menu", \
  NULL

#define RTTY_WINDOW_IDS \
  "rtty_window", \
  "rtty_squelch_adj", \
  NULL

//------------------------------------------------------------------

/* Create_Rtty_Window()
 *
 * Creates the main window for RTTY
 */
  GtkWidget *
Create_Rtty_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { RTTY_WINDOW_IDS };

  // Initialize Digimode and DUC Send semaphore
  if( !Init_Semaphore(&digimode_semaphore, True) )
    return( NULL );
  if( !Init_Semaphore(&duc_send_semaphore, True) )
    return( NULL );
  xmit_buffer.xmit_buf_i = NULL;
  xmit_buffer.xmit_buf_q = NULL;

  // Create the rtty glade file name
  Strlcpy( rtty_rc.rtty_glade,
      getenv("HOME"), sizeof(rtty_rc.rtty_glade) );
  Strlcat( rtty_rc.rtty_glade,
      "/.hermes2/rtty/rtty.glade", sizeof(rtty_rc.rtty_glade) );

  // Create rtty main window
  Gtk_Builder( builder, rtty_rc.rtty_glade, object_ids );
  rtty_gui.window = Builder_Get_Object( *builder, "rtty_window" );

  // Get Rx text buffer and viewer
  rtty_gui.rx_text_view =
    GTK_TEXT_VIEW( Builder_Get_Object(rtty_gui.window_builder, "rtty_rx_textview") );
  rtty_gui.rx_text_buffer = gtk_text_view_get_buffer( rtty_gui.rx_text_view );

  // Get Tx text buffer and viewer
  rtty_gui.tx_text_view =
    GTK_TEXT_VIEW( Builder_Get_Object(rtty_gui.window_builder, "rtty_tx_textview") );
  rtty_gui.tx_text_buffer = gtk_text_view_get_buffer( rtty_gui.tx_text_view );

  // Get scope widget
  rtty_wfall.canvas =
    Builder_Get_Object( rtty_gui.window_builder, "rtty_scope2_drawingarea" );
  rtty_gui.rtty_scope =
    Builder_Get_Object( rtty_gui.window_builder, "rtty_scope1_drawingarea" );
  rtty_gui.scope_label = Builder_Get_Object( rtty_gui.window_builder, "rtty_scope_label" );

  // Set labels to Xmit and Rcve buttons
  GtkWidget *button =
    Builder_Get_Object( rtty_gui.window_builder, "rtty_transmit" );
  rtty_gui.xmit_status = gtk_label_new( _("TRANSMIT") );
  gtk_widget_show( rtty_gui.xmit_status );
  gtk_container_add( GTK_CONTAINER(button), rtty_gui.xmit_status );
  g_object_set_data_full( G_OBJECT(rtty_gui.window), "rtty_xmit_status",
      g_object_ref(rtty_gui.xmit_status), (GDestroyNotify)g_object_unref );

  button = Builder_Get_Object( rtty_gui.window_builder, "rtty_receive" );
  rtty_gui.rcve_status = gtk_label_new( _("RECEIVE") );
  gtk_widget_show( rtty_gui.rcve_status );
  gtk_container_add( GTK_CONTAINER(button), rtty_gui.rcve_status );
  g_object_set_data_full( G_OBJECT(rtty_gui.window), "rtty_receive_status",
      g_object_ref( rtty_gui.rcve_status ), (GDestroyNotify)g_object_unref );

  // Set the SHIFT button label
  button = Builder_Get_Object( rtty_gui.window_builder, "rtty_shift" );
  rtty_gui.shift_label = gtk_label_new( _("LTRS") );
  gtk_widget_show( rtty_gui.shift_label );
  gtk_container_add( GTK_CONTAINER(button), rtty_gui.shift_label );
  gtk_label_set_justify( GTK_LABEL(rtty_gui.shift_label), GTK_JUSTIFY_LEFT );
  g_object_set_data_full( G_OBJECT(button), "shift_label",
      g_object_ref(rtty_gui.shift_label), (GDestroyNotify)g_object_unref);

  // Get waterfall size
  GtkAllocation alloc;
  gtk_widget_get_allocation( rtty_wfall.canvas, &alloc );
  if( !Create_Wfall_Pixbuf( &rtty_wfall, &rtty_ifft_data,
        (uint16_t)alloc.width, (uint16_t)alloc.height) )
    Error_Dialog( _("Failed to create pixbuf for waterfall"), HIDE_OK );

  // Get scope size
  gtk_widget_get_allocation( rtty_gui.rtty_scope, &alloc );
  rtty_gui.rtty_scope_width  = (uint16_t)alloc.width;
  rtty_gui.rtty_scope_height = (uint16_t)alloc.height;

  // Create the popup menu
  rtty_gui.popup_menu = Rtty_Popup_Menu( &rtty_gui.popup_menu_builder );

  // Set up Receive text view
  gtk_text_buffer_get_iter_at_offset(
      rtty_gui.rx_text_buffer, &rtty_gui.rx_text_buffer_iter, 0 );
  rx_print_chr.iter = &rtty_gui.rx_text_buffer_iter;

  // Prepare data for Rx Print_Character()
  rx_print_chr.text_view     = rtty_gui.rx_text_view;
  rx_print_chr.text_buffer   = rtty_gui.rx_text_buffer;
  rx_print_chr.rx_mode       = True;
  rx_print_chr.printchr      = LF;

  // Prepare data for Tx Print_Character()
  tx_print_chr.text_view     = rtty_gui.tx_text_view;
  tx_print_chr.text_buffer   = rtty_gui.tx_text_buffer;
  tx_print_chr.rx_mode       = False;
  tx_print_chr.printchr      = LF;

  // Set up Transmit text view
  gtk_text_buffer_get_iter_at_offset(
      rtty_gui.tx_text_buffer, &rtty_gui.tx_text_buffer_iter, 0 );
  tx_print_chr.iter = &rtty_gui.tx_text_buffer_iter;

  // Load runtime config file, abort on error
  g_idle_add( Rtty_Read_Config, NULL );
  while( g_main_context_iteration(NULL, FALSE) );

  Flag[GUEST_QUIT] = False;

  return( rtty_gui.window );
} // Create_Rtty_Window()

//------------------------------------------------------------------

/* Rtty_Popup_Menu()
 *
 * Creates the RTTY popup menu
 */
  GtkWidget *
Rtty_Popup_Menu( GtkBuilder **builder )
{
  gchar *object_ids[] = { RTTY_POPUP_MENU_IDS };
  Gtk_Builder( builder, rtty_rc.rtty_glade, object_ids );
  GtkWidget *menu = Builder_Get_Object( *builder, "rtty_popup_menu" );
  return( menu );
} // Rtty_Popup_Menu()

//------------------------------------------------------------------

