/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef RTTY_DISPLAY_H
#define RTTY_DISPLAY_H   1

#include "../common/guest_utils.h"
#include <cairo/cairo.h>
#include <gtk/gtk.h>

// display.c
void Rtty_Display_Waterfall(pixbuffer_t *wfall, ifft_data_t *ifft_data);
void Rtty_Display_Synchro(cairo_t *cr, uint8_t sync_pos, uint8_t sync_lev);
void Rtty_Display_Signal(cairo_t *cr, GdkPoint *points);
gboolean Rtty_Set_TxRx_Labels(gpointer data);
gboolean Rtty_Set_Shift_Label(gpointer data);

#endif

