/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef RTTY_CALLBACKS_H
#define RTTY_CALLBACKS_H   1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

// callbacks.c
void on_rtty_window_destroy(GObject *object, gpointer user_data);
gboolean on_rtty_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_rtty_quit_activate(GtkMenuItem *menuitem, gpointer user_data);
gboolean on_rtty_tx_textview_key_press(GtkWidget *widget, const GdkEventKey *event, gpointer user_data);
gboolean on_rtty_tx_textview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
gboolean on_rtty_rx_textview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_rtty_transmit_clicked(GtkButton *button, gpointer user_data);
void on_rtty_receive_clicked(GtkButton *button, gpointer user_data);
void on_rtty_squelch_value_changed(GtkRange *range, gpointer user_data);
gboolean on_rtty_scope1_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_rtty_scope2_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_rtty_scope2_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_rtty_scope_label_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_rtty_callsign_changed(GtkEditable *editable, gpointer user_data);
void on_rtty_rst_out_changed(GtkEditable *editable, gpointer user_data);
void on_rtty_rst_in_changed(GtkEditable *editable, gpointer user_data);
void on_rtty_op_name_changed(GtkEditable *editable, gpointer user_data);
void on_rtty_qth_name_changed(GtkEditable *editable, gpointer user_data);
void on_rtty_locator_changed(GtkEditable *editable, gpointer user_data);
void on_rtty_band_changed(GtkEditable *editable, gpointer user_data);
void on_rtty_new_record_clicked(GtkButton *button, gpointer user_data);
void on_rtty_save_record_clicked(GtkButton *button, gpointer user_data);
void on_rtty_clear_fields_clicked(GtkButton *button, gpointer user_data);
void on_rtty_clear_window_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_clear_windows_clicked(GtkButton *button, gpointer user_data);
void on_rtty_macro_clicked(GtkButton *button, gpointer user_data);
void on_rtty_bd45_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_bd50_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_bd75_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_bd100_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_afsk85_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_afsk170_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_afsk200_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_afsk250_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_afsk450_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_afsk850_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_stop10_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_stop15_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_stop20_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_usos_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_record_qsos_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_identify_in_cw_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_reverse_afsk_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_rtty_shift_clicked(GtkButton *button, gpointer user_data);
void on_rtty_enable_diversity_activate(GtkMenuItem *menuitem, gpointer user_data);

#endif

