/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef RTTY_CALLBACK_FUNC_H
#define RTTY_CALLBACK_FUNC_H    1

#include "../common/common.h"
#include "../common/ifft.h"
#include <gtk/gtk.h>

// callback_func.c
void Rtty_Change_Modes(void);
void Rtty_Receive_Clicked(void);
gboolean Rtty_Textview_Button_Press(const GdkEventButton *event);
gboolean Rtty_Tx_Textview_Key_Press(const GdkEventKey *event);
void Rtty_Select_Macro(GtkButton *button);
void Rtty_Tune_to_Monitor(const GdkEventButton *event, uint8_t tune_range, uint16_t wfall_width, uint16_t center_freq, ifft_data_t *ifft_data);

#endif

