/*
 *  This file was derived from the C++ source code files in src/rsid/
 *  of the fldigi package. Below is the original copyright notice.
 *  fldigi is a GNU GPL licensed application and so is hermes2.
 *
 *  Copyright (C) 2008-2012
 *        Dave Freese, W1HKJ
 *   Copyright (C) 2009-2012
 *        Stelios Bounanos, M0GLD
 *   Copyright (C) 2012
 *        John Douyere, VK2ETA
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef RSID_MODES_H
#define RSID_MODES_H    1

enum _MODES
{
  MODE_ESCAPE,
  MODE_PSK31,
  MODE_QPSK31,
  MODE_PSK63,
  MODE_QPSK63,
  MODE_PSK125,
  MODE_QPSK125,
  MODE_PSK250,
  MODE_QPSK250,
  MODE_PSK500,
  MODE_PSK125R,
  MODE_PSK250R,
  MODE_PSK500R,
  MODE_PSKFEC31,
  MODE_PSK10,
  MODE_MT63_500L,
  MODE_MT63_500S,
  MODE_MT63_500_VST,
  MODE_MT63_1000L,
  MODE_MT63_1000S,
  MODE_MT63_1000_VST,
  MODE_MT63_2000L,
  MODE_MT63_2000S,
  MODE_MT63_2000_VST,
  MODE_PSKAM10,
  MODE_PSKAM31,
  MODE_PSKAM50,
  MODE_PSK63F,
  MODE_PSK220F,
  MODE_CHIP64,
  MODE_CHIP128,
  MODE_CW,
  MODE_CCW_OOK_12,
  MODE_CCW_OOK_24,
  MODE_CCW_OOK_48,
  MODE_CCW_FSK_12,
  MODE_CCW_FSK_24,
  MODE_CCW_FSK_48,
  MODE_PACTOR1_FEC,
  MODE_PACKET_110,
  MODE_PACKET_300,
  MODE_PACKET_1200,
  MODE_RTTY_ASCII_7,
  MODE_RTTY_ASCII_8,
  MODE_RTTY_45,
  MODE_RTTY_50,
  MODE_RTTY_75,
  MODE_AMTOR_FEC,
  MODE_THROB1,
  MODE_THROB2,
  MODE_THROB4,
  MODE_THROBX1,
  MODE_THROBX2,
  MODE_THROBX4,
  MODE_CONTESTIA_4_125,
  MODE_CONTESTIA_4_250,
  MODE_CONTESTIA_4_500,
  MODE_CONTESTIA_4_1000,
  MODE_CONTESTIA_4_2000,
  MODE_CONTESTIA_8_125,
  MODE_CONTESTIA_8_250,
  MODE_CONTESTIA_8_500,
  MODE_CONTESTIA_8_1000,
  MODE_CONTESTIA_8_2000,
  MODE_CONTESTIA_16_500,
  MODE_CONTESTIA_16_1000,
  MODE_CONTESTIA_16_2000,
  MODE_CONTESTIA_32_1000,
  MODE_CONTESTIA_32_2000,
  MODE_CONTESTIA_64_500,
  MODE_CONTESTIA_64_1000,
  MODE_CONTESTIA_64_2000,
  MODE_VOICE,
  MODE_MFSK8,
  MODE_MFSK16,
  MODE_MFSK32,
  MODE_MFSK11,
  MODE_MFSK22,
  MODE_RTTYM_8_250,
  MODE_RTTYM_16_500,
  MODE_RTTYM_32_1000,
  MODE_RTTYM_8_500,
  MODE_RTTYM_16_1000,
  MODE_RTTYM_4_500,
  MODE_RTTYM_4_250,
  MODE_RTTYM_8_1000,
  MODE_RTTYM_8_125,
  MODE_OLIVIA_4_125,
  MODE_OLIVIA_4_250,
  MODE_OLIVIA_4_500,
  MODE_OLIVIA_4_1000,
  MODE_OLIVIA_4_2000,
  MODE_OLIVIA_8_125,
  MODE_OLIVIA_8_250,
  MODE_OLIVIA_8_500,
  MODE_OLIVIA_8_1000,
  MODE_OLIVIA_8_2000,
  MODE_OLIVIA_16_500,
  MODE_OLIVIA_16_1000,
  MODE_OLIVIA_16_2000,
  MODE_OLIVIA_32_1000,
  MODE_OLIVIA_32_2000,
  MODE_OLIVIA_64_2000,
  MODE_PAX,
  MODE_PAX2,
  MODE_DOMINOF,
  MODE_FAX,
  MODE_SSTV,
  MODE_DOMINOEX4,
  MODE_DOMINOEX5,
  MODE_DOMINOEX8,
  MODE_DOMINOEX11,
  MODE_DOMINOEX16,
  MODE_DOMINOEX22,
  MODE_DOMINOEX4_FEC,
  MODE_DOMINOEX5_FEC,
  MODE_DOMINOEX8_FEC,
  MODE_DOMINOEX11_FEC,
  MODE_DOMINOEX16_FEC,
  MODE_DOMINOEX22_FEC,
  MODE_FELDHELL,
  MODE_PSK_HELL,
  MODE_HELL80,
  MODE_FSKH105,
  MODE_FSKH245,
  MODE_141A,
  MODE_DTMF,
  MODE_ALE400,
  MODE_FDMDV,
  MODE_JT65_A,
  MODE_JT65_B,
  MODE_JT65_C,
  MODE_THOR4,
  MODE_THOR8,
  MODE_THOR16,
  MODE_THOR5,
  MODE_THOR11,
  MODE_THOR22,
  MODE_CALL_ID,
  MODE_PACKET_PSK1200,
  MODE_PACKET_PSK250,
  MODE_PACKET_PSK63,
  MODE_188_110A_8N1,
  MODE_4X_PSK63R,
  MODE_5X_PSK63R,
  MODE_10X_PSK63R,
  MODE_20X_PSK63R,
  MODE_32X_PSK63R,
  MODE_4X_PSK125R,
  MODE_5X_PSK125R,
  MODE_10X_PSK125R,
  MODE_12X_PSK125,
  MODE_12X_PSK125R,
  MODE_16X_PSK125R,
  MODE_2X_PSK250R,
  MODE_3X_PSK250R,
  MODE_5X_PSK250R,
  MODE_6X_PSK250,
  MODE_6X_PSK250R,
  MODE_7X_PSK250R,
  MODE_2X_PSK500R,
  MODE_3X_PSK500R,
  MODE_4X_PSK500R,
  MODE_2X_PSK500,
  MODE_4X_PSK500,
  MODE_PSK1000,
  MODE_PSK1000R,
  MODE_2X_PSK1000,
  MODE_2X_PSK1000R,
  MODE_2X_PSK800R,
  MODE_2X_PSK800,
  MODE_MFSK64,
  MODE_MFSK128,
  MODE_THOR25X4,
  MODE_THOR50X1,
  MODE_THOR50X2,
  MODE_THOR100,
  MODE_DOMINOEX44,
  MODE_DOMINOEX88,
  MODE_MFSK31,
  MODE_DOMINOEXMICRO,
  MODE_THORMICRO,
  MODE_MFSK64L,
  MODE_MFSK128L,
  MODE_8PSK125,
  MODE_8PSK250,
  MODE_8PSK500,
  MODE_8PSK1000,
  MODE_8PSK125F,
  MODE_8PSK250F,
  MODE_8PSK500F,
  MODE_8PSK1000F,
  MODE_8PSK1200F,
  MODE_8PSK125FL,
  MODE_8PSK250FL,
  MODE_IFKP,
  NUM_MODES,
  MODE_NULL   // My addition, to suppress RSID transmission when not needed
};

#undef ELEM1_
#define RSID_LIST1 \
  ELEM1_(6,   ESCAPE,  MODE_ESCAPE) \
  ELEM1_(1,   BPSK31,  MODE_PSK31) \
  ELEM1_(110, QPSK31,  MODE_QPSK31) \
  ELEM1_(2,   BPSK63,  MODE_PSK63) \
  ELEM1_(3,   QPSK63,  MODE_QPSK63) \
  ELEM1_(4,   BPSK125, MODE_PSK125) \
  ELEM1_(5,   QPSK125, MODE_QPSK125) \
  ELEM1_(126, BPSK250, MODE_PSK250) \
  ELEM1_(127, QPSK250, MODE_QPSK250) \
  ELEM1_(173, BPSK500, MODE_PSK500) \
  \
  ELEM1_(183, PSK125R, MODE_PSK125R) \
  ELEM1_(186, PSK250R, MODE_PSK250R) \
  ELEM1_(187, PSK500R, MODE_PSK500R) \
  \
  ELEM1_(7, PSKFEC31, MODE_PSKFEC31) \
  ELEM1_(8, PSK10,    MODE_PSK10) \
  \
  ELEM1_(9,  MT63_500_LG,   MODE_MT63_500L) \
  ELEM1_(10, MT63_500_ST,   MODE_MT63_500S) \
  ELEM1_(11, MT63_500_VST,  MODE_MT63_500_VST) \
  ELEM1_(12, MT63_1000_LG,  MODE_MT63_1000L) \
  ELEM1_(13, MT63_1000_ST,  MODE_MT63_1000S) \
  ELEM1_(14, MT63_1000_VST, MODE_MT63_1000_VST) \
  ELEM1_(15, MT63_2000_LG,  MODE_MT63_2000L) \
  ELEM1_(17, MT63_2000_ST,  MODE_MT63_2000S) \
  ELEM1_(18, MT63_2000_VST, MODE_MT63_2000_VST) \
  \
  ELEM1_(19, PSKAM10, MODE_PSKAM10) \
  ELEM1_(20, PSKAM31, MODE_PSKAM31) \
  ELEM1_(21, PSKAM50, MODE_PSKAM50) \
  \
  ELEM1_(22, PSK63F,  MODE_PSK63F) \
  ELEM1_(23, PSK220F, MODE_PSK220F) \
  \
  ELEM1_(24, CHIP64,  MODE_CHIP64) \
  ELEM1_(25, CHIP128, MODE_CHIP128) \
  \
  ELEM1_(26, CW, MODE_CW) \
  \
  ELEM1_(27, CCW_OOK_12, MODE_CCW_OOK_12) \
  ELEM1_(28, CCW_OOK_24, MODE_CCW_OOK_24) \
  ELEM1_(29, CCW_OOK_48, MODE_CCW_OOK_48) \
  ELEM1_(30, CCW_FSK_12, MODE_CCW_FSK_12) \
  ELEM1_(31, CCW_FSK_24, MODE_CCW_FSK_24) \
  ELEM1_(33, CCW_FSK_48, MODE_CCW_FSK_48) \
  \
  ELEM1_(34, PACTOR1_FEC, MODE_PACTOR1_FEC) \
  \
  ELEM1_(113, PACKET_110,  MODE_PACKET_110) \
  ELEM1_(35,  PACKET_300,  MODE_PACKET_300) \
  ELEM1_(36,  PACKET_1200, MODE_PACKET_1200) \
  \
  ELEM1_(37, RTTY_ASCII_7, MODE_RTTY_ASCII_7) \
  ELEM1_(38, RTTY_ASCII_8, MODE_RTTY_ASCII_8) \
  ELEM1_(39, RTTY_45,      MODE_RTTY_45) \
  ELEM1_(40, RTTY_50,      MODE_RTTY_50) \
  ELEM1_(41, RTTY_75,      MODE_RTTY_75) \
  \
  ELEM1_(42, AMTOR_FEC, MODE_AMTOR_FEC) \
  \
  ELEM1_(43,  THROB_1,  MODE_THROB1) \
  ELEM1_(44,  THROB_2,  MODE_THROB2) \
  ELEM1_(45,  THROB_4,  MODE_THROB4) \
  ELEM1_(46,  THROBX_1, MODE_THROBX1) \
  ELEM1_(47,  THROBX_2, MODE_THROBX2) \
  ELEM1_(146, THROBX_4, MODE_THROBX4) \
  \
  ELEM1_(204, CONTESTIA_4_125,  MODE_CONTESTIA_4_125) \
  ELEM1_(55,  CONTESTIA_4_250,  MODE_CONTESTIA_4_250) \
  ELEM1_(54,  CONTESTIA_4_500,  MODE_CONTESTIA_4_500) \
  ELEM1_(255, CONTESTIA_4_1000, MODE_CONTESTIA_4_1000) \
  ELEM1_(254, CONTESTIA_4_2000, MODE_CONTESTIA_4_2000) \
  \
  ELEM1_(169, CONTESTIA_8_125,  MODE_CONTESTIA_8_125) \
  ELEM1_(49,  CONTESTIA_8_250,  MODE_CONTESTIA_8_250) \
  ELEM1_(52,  CONTESTIA_8_500,  MODE_CONTESTIA_8_500) \
  ELEM1_(117, CONTESTIA_8_1000, MODE_CONTESTIA_8_1000) \
  ELEM1_(247, CONTESTIA_8_2000, MODE_CONTESTIA_8_2000) \
  \
  ELEM1_(50,  CONTESTIA_16_500,  MODE_CONTESTIA_16_500) \
  ELEM1_(53,  CONTESTIA_16_1000, MODE_CONTESTIA_16_1000) \
  ELEM1_(259, CONTESTIA_16_2000, MODE_CONTESTIA_16_2000) \
  \
  ELEM1_(51,  CONTESTIA_32_1000, MODE_CONTESTIA_32_1000) \
  ELEM1_(201, CONTESTIA_32_2000, MODE_CONTESTIA_32_2000) \
  \
  ELEM1_(194, CONTESTIA_64_500,  MODE_CONTESTIA_64_500) \
  ELEM1_(193, CONTESTIA_64_1000, MODE_CONTESTIA_64_1000) \
  ELEM1_(191, CONTESTIA_64_2000, MODE_CONTESTIA_64_2000) \
  \
  ELEM1_(56, VOICE, MODE_VOICE) \
  \
  ELEM1_(60,  MFSK8,  MODE_MFSK8) \
  ELEM1_(57,  MFSK16, MODE_MFSK16) \
  ELEM1_(147, MFSK32, MODE_MFSK32) \
  \
  ELEM1_(148, MFSK11, MODE_MFSK11) \
  ELEM1_(152, MFSK22, MODE_MFSK22) \
  \
  ELEM1_(61,  RTTYM_8_250,   MODE_RTTYM_8_250) \
  ELEM1_(62,  RTTYM_16_500,  MODE_RTTYM_16_500) \
  ELEM1_(63,  RTTYM_32_1000, MODE_RTTYM_32_1000) \
  ELEM1_(65,  RTTYM_8_500,   MODE_RTTYM_8_500) \
  ELEM1_(66,  RTTYM_16_1000, MODE_RTTYM_16_1000) \
  ELEM1_(67,  RTTYM_4_500,   MODE_RTTYM_4_500) \
  ELEM1_(68,  RTTYM_4_250,   MODE_RTTYM_4_250) \
  ELEM1_(119, RTTYM_8_1000,  MODE_RTTYM_8_1000) \
  ELEM1_(170, RTTYM_8_125,   MODE_RTTYM_8_125) \
  \
  ELEM1_(203, OLIVIA_4_125,  MODE_OLIVIA_4_125) \
  ELEM1_(75,  OLIVIA_4_250,  MODE_OLIVIA_4_250) \
  ELEM1_(74,  OLIVIA_4_500,  MODE_OLIVIA_4_500) \
  ELEM1_(229, OLIVIA_4_1000, MODE_OLIVIA_4_1000) \
  ELEM1_(238, OLIVIA_4_2000, MODE_OLIVIA_4_2000) \
  \
  ELEM1_(163, OLIVIA_8_125,  MODE_OLIVIA_8_125) \
  ELEM1_(69,  OLIVIA_8_250,  MODE_OLIVIA_8_250) \
  ELEM1_(72,  OLIVIA_8_500,  MODE_OLIVIA_8_500) \
  ELEM1_(116, OLIVIA_8_1000, MODE_OLIVIA_8_1000) \
  ELEM1_(214, OLIVIA_8_2000, MODE_OLIVIA_8_2000) \
  \
  ELEM1_(70,  OLIVIA_16_500,  MODE_OLIVIA_16_500) \
  ELEM1_(73,  OLIVIA_16_1000, MODE_OLIVIA_16_1000) \
  ELEM1_(234, OLIVIA_16_2000, MODE_OLIVIA_16_2000) \
  \
  ELEM1_(71,  OLIVIA_32_1000, MODE_OLIVIA_32_1000) \
  ELEM1_(221, OLIVIA_32_2000, MODE_OLIVIA_32_2000) \
  \
  ELEM1_(211, OLIVIA_64_2000, MODE_OLIVIA_64_2000) \
  \
  ELEM1_(76, PAX,     MODE_PAX) \
  ELEM1_(77, PAX2,    MODE_PAX2) \
  ELEM1_(78, DOMINOF, MODE_DOMINOF) \
  ELEM1_(79, FAX,     MODE_FAX) \
  ELEM1_(81, SSTV,    MODE_SSTV) \
  \
  ELEM1_(84,  DOMINOEX_4,      MODE_DOMINOEX4) \
  ELEM1_(85,  DOMINOEX_5,      MODE_DOMINOEX5) \
  ELEM1_(86,  DOMINOEX_8,      MODE_DOMINOEX8) \
  ELEM1_(87,  DOMINOEX_11,     MODE_DOMINOEX11) \
  ELEM1_(88,  DOMINOEX_16,     MODE_DOMINOEX16) \
  ELEM1_(90,  DOMINOEX_22,     MODE_DOMINOEX22) \
  ELEM1_(92,  DOMINOEX_4_FEC,  MODE_DOMINOEX4_FEC) \
  ELEM1_(93,  DOMINOEX_5_FEC,  MODE_DOMINOEX5_FEC) \
  ELEM1_(97,  DOMINOEX_8_FEC,  MODE_DOMINOEX8_FEC) \
  ELEM1_(98,  DOMINOEX_11_FEC, MODE_DOMINOEX11_FEC) \
  ELEM1_(99,  DOMINOEX_16_FEC, MODE_DOMINOEX16_FEC) \
  ELEM1_(101, DOMINOEX_22_FEC, MODE_DOMINOEX22_FEC) \
  \
  ELEM1_(104, FELD_HELL,   MODE_FELDHELL) \
  ELEM1_(105, PSK_HELL,    MODE_PSK_HELL) \
  ELEM1_(106, HELL_80,     MODE_HELL80) \
  ELEM1_(107, FM_HELL_105, MODE_FSKH105) \
  ELEM1_(108, FM_HELL_245, MODE_FSKH245) \
  \
  ELEM1_(114, MODE_141A, MODE_141A) \
  ELEM1_(123, DTMF,      MODE_DTMF) \
  ELEM1_(125, ALE400,    MODE_ALE400) \
  ELEM1_(131, FDMDV,     MODE_FDMDV) \
  \
  ELEM1_(132, JT65_A, MODE_JT65_A) \
  ELEM1_(134, JT65_B, MODE_JT65_B) \
  ELEM1_(135, JT65_C, MODE_JT65_C) \
  \
  ELEM1_(136, THOR_4,  MODE_THOR4) \
  ELEM1_(137, THOR_8,  MODE_THOR8) \
  ELEM1_(138, THOR_16, MODE_THOR16) \
  ELEM1_(139, THOR_5,  MODE_THOR5) \
  ELEM1_(143, THOR_11, MODE_THOR11) \
  ELEM1_(145, THOR_22, MODE_THOR22) \
  \
  ELEM1_(153, CALL_ID, MODE_CALL_ID) \
  \
  ELEM1_(155, PACKET_PSK1200, MODE_PACKET_PSK1200) \
  ELEM1_(156, PACKET_PSK250,  MODE_PACKET_PSK250) \
  ELEM1_(159, PACKET_PSK63,   MODE_PACKET_PSK63) \
  \
  ELEM1_(172, MODE_188_110A_8N1, MODE_188_110A_8N1) \
  \
  ELEM1_(0, NONE1, NUM_MODES)

#undef ELEM2_
#define RSID_LIST2 \
  ELEM2_(450, PSK63RX4,  MODE_4X_PSK63R) \
  ELEM2_(457, PSK63RX5,  MODE_5X_PSK63R) \
  ELEM2_(458, PSK63RX10, MODE_10X_PSK63R) \
  ELEM2_(460, PSK63RX20, MODE_20X_PSK63R) \
  ELEM2_(462, PSK63RX32, MODE_32X_PSK63R) \
  \
  ELEM2_(467, PSK125RX4,  MODE_4X_PSK125R) \
  ELEM2_(497, PSK125RX5,  MODE_5X_PSK125R) \
  ELEM2_(513, PSK125RX10, MODE_10X_PSK125R) \
  ELEM2_(519, PSK125X12,  MODE_12X_PSK125) \
  ELEM2_(522, PSK125RX12, MODE_12X_PSK125R) \
  ELEM2_(527, PSK125RX16, MODE_16X_PSK125R) \
  \
  ELEM2_(529, PSK250RX2, MODE_2X_PSK250R) \
  ELEM2_(533, PSK250RX3, MODE_3X_PSK250R) \
  ELEM2_(539, PSK250RX5, MODE_5X_PSK250R) \
  ELEM2_(541, PSK250X6,  MODE_6X_PSK250) \
  ELEM2_(545, PSK250RX6, MODE_6X_PSK250R) \
  ELEM2_(551, PSK250RX7, MODE_7X_PSK250R) \
  \
  ELEM2_(553, PSK500RX2, MODE_2X_PSK500R) \
  ELEM2_(558, PSK500RX3, MODE_3X_PSK500R) \
  ELEM2_(564, PSK500RX4, MODE_4X_PSK500R) \
  ELEM2_(566, PSK500X2,  MODE_2X_PSK500) \
  ELEM2_(569, PSK500X4,  MODE_4X_PSK500) \
  \
  ELEM2_(570, PSK1000,    MODE_PSK1000) \
  ELEM2_(580, PSK1000R,   MODE_PSK1000R) \
  ELEM2_(587, PSK1000X2,  MODE_2X_PSK1000) \
  ELEM2_(595, PSK1000RX2, MODE_2X_PSK1000R) \
  ELEM2_(604, PSK800RX2,  MODE_2X_PSK800R) \
  ELEM2_(610, PSK800X2,   MODE_2X_PSK800) \
  \
  ELEM2_(620, MFSK64,  MODE_MFSK64) \
  ELEM2_(625, MFSK128, MODE_MFSK128) \
  \
  ELEM2_(639, THOR25X4, MODE_THOR25X4) \
  ELEM2_(649, THOR50X1, MODE_THOR50X1) \
  ELEM2_(653, THOR50X2, MODE_THOR50X2) \
  ELEM2_(658, THOR100,  MODE_THOR100) \
  \
  ELEM2_(662, DOMINOEX_44, MODE_DOMINOEX44) \
  ELEM2_(681, DOMINOEX_88, MODE_DOMINOEX88) \
  \
  ELEM2_(687, MFSK31, MODE_MFSK31) \
  \
  ELEM2_(691, DOMINOEX_MICRO, MODE_DOMINOEXMICRO) \
  ELEM2_(693, THOR_MICRO,     MODE_THORMICRO) \
  \
  ELEM2_(1026, MFSK64L,  MODE_MFSK64L) \
  ELEM2_(1029, MFSK128L, MODE_MFSK128L) \
  \
  ELEM2_(1066, PSK8P125,  MODE_8PSK125) \
  ELEM2_(1071, PSK8P250,  MODE_8PSK250) \
  ELEM2_(1076, PSK8P500,  MODE_8PSK500) \
  ELEM2_(1047, PSK8P1000, MODE_8PSK1000) \
  \
  ELEM2_(1037, PSK8P125F,  MODE_8PSK125F) \
  ELEM2_(1038, PSK8P250F,  MODE_8PSK250F) \
  ELEM2_(1043, PSK8P500F,  MODE_8PSK500F) \
  ELEM2_(1078, PSK8P1000F, MODE_8PSK1000F) \
  ELEM2_(1058, PSK8P1200F, MODE_8PSK1200F) \
  \
  ELEM2_(1239, PSK8P125FL, MODE_8PSK125FL) \
  ELEM2_(2052, PSK8P250FL, MODE_8PSK250FL) \
  \
  ELEM2_(1171, IFKP, MODE_IFKP) \
  \
  ELEM2_(0, NONE2, NUM_MODES)

#endif

