/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef PSK31_SHARED_H
#define PSK31_SHARED_H    1

#include "../common/common.h"
#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include "../common/utils.h"
#include <gtk/gtk.h>

//------------------------------------------------------------------------

// Frequency in Hz of phase detector (BFO pitch)
#define PSK31_AUDIO_FREQUENCY   500

// 'NULL' character used as 'last character' flag
#define PSK31_NULL_CHAR   0x00

// Configuration parameters structure
typedef struct _PSK31_RC
{
  // Four quadrants of a signal cycle (in dsp samples)
  double
    quadrant_1,
    quadrant_2,
    quadrant_3,
    quadrant_4;

  uint8_t
    tx_preamble_tone, // Transmit preamble tone duration in DAC samples
    tx_preamble_rev,  // Preamble or postamble reversals
    word_wrap;        // Word wrap column number

  uint16_t
    rx_psk_element,    // Duration of receive PSK element in ADC samples
    rx_psk_element2,   // Duration of receive half PSK element in ADC samples
    tx_psk_element,    // Duration of receive PSK element in ADC samples
    tx_psk_element2,   // Duration of receive half PSK element in ADC samples
    tx_tone_period,    // Period of TX audio tone in DAC cycles
    squelch_threshold; // Receive squelch threshold

  // Reverse the sense of the magniphase indicators
  BOOLEAN rev_magniphase;

  char
    psk31_glade[FILE_NAME_SIZE],  // Psk31 glade file path
    rc_fpath[FILE_NAME_SIZE];     // File path to psk31rc

} psk31_rc_t;

// Runtime config data
extern psk31_rc_t psk31_rc;

//------------------------------------------------------------------------

// Psk31 GUI widgets
typedef struct _PSK31_GUI
{
  GtkWidget
    *window,
    *popup_menu,
    *xmit_status,
    *rcve_status,
    *psk31_scope;

  // Builder objects for main window and menu
  GtkBuilder *window_builder, *popup_menu_builder;

  // Text viewers
  GtkTextView *rx_text_view, *tx_text_view;

  // Text buffers for text viewers
  GtkTextBuffer *rx_text_buffer, *tx_text_buffer;
  GtkTextIter tx_text_buffer_iter, rx_text_buffer_iter;

  uint16_t psk31_scope_width, psk31_scope_height;

} psk31_gui_t;

extern psk31_gui_t psk31_gui;

// Psk31 waterfall
extern pixbuffer_t psk31_wfall;

// IFFT() data object
extern ifft_data_t psk31_ifft_data;

// Macros attached to F1-F10
extern char *psk31_macro[NUM_OF_LABELS];

//------------------------------------------------------------------------

#endif

