/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */
#include "interface.h"
#include "display.h"
#include "shared.h"
#include "utils.h"
#include "../common/common.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include <gtk/gtk.h>
#include <stdint.h>
#include <stdlib.h>

//------------------------------------------------------------------

#define PSK31_POPUP_MENU_IDS \
  "psk31_popup_menu", \
  NULL

#define PSK31_WINDOW_IDS \
  "psk31_window", \
  "psk31_freq_adjustment", \
  "psk31_squelch_adjustment", \
  "psk31_rxscroll_adjustment", \
  NULL

//------------------------------------------------------------------

/* Create_Psk31_Window()
 *
 * Creates the main window for PSK31
 */
  GtkWidget *
Create_Psk31_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { PSK31_WINDOW_IDS };

  // Initialize Digimode and DUC Send semaphore
  if( !Init_Semaphore(&digimode_semaphore, True) )
    return( NULL );
  if( !Init_Semaphore(&duc_send_semaphore, True) )
    return( NULL );
  xmit_buffer.xmit_buf_i = NULL;
  xmit_buffer.xmit_buf_q = NULL;

  // Create the psk31 glade file name
  Strlcpy( psk31_rc.psk31_glade,
      getenv("HOME"), sizeof(psk31_rc.psk31_glade) );
  Strlcat( psk31_rc.psk31_glade,
      "/.hermes2/psk31/psk31.glade", sizeof(psk31_rc.psk31_glade) );

  // Create psk31 main window
  Gtk_Builder( builder, psk31_rc.psk31_glade, object_ids );
  psk31_gui.window = Builder_Get_Object( *builder, "psk31_window" );

  // Get Rx text buffer and scroller
  psk31_gui.rx_text_view =
    GTK_TEXT_VIEW( Builder_Get_Object(psk31_gui.window_builder, "psk31_rx_textview") );
  psk31_gui.rx_text_buffer = gtk_text_view_get_buffer( psk31_gui.rx_text_view );

  // Get Tx text buffer and scroller
  psk31_gui.tx_text_view =
    GTK_TEXT_VIEW( Builder_Get_Object(psk31_gui.window_builder, "psk31_tx_textview") );
  psk31_gui.tx_text_buffer = gtk_text_view_get_buffer( psk31_gui.tx_text_view );

  // Get waterfall widget
  psk31_wfall.canvas =
    Builder_Get_Object( psk31_gui.window_builder, "psk31_wfall_drawingarea" );

  // Get scope widget
  psk31_gui.psk31_scope =
    Builder_Get_Object( psk31_gui.window_builder, "psk31_scope_drawingarea" );

  // Set labels to Xmit and Rcve buttons
  GtkWidget *button =
    Builder_Get_Object( psk31_gui.window_builder, "psk31_transmit" );
  psk31_gui.xmit_status = gtk_label_new( _("TRANSMIT") );
  gtk_widget_show( psk31_gui.xmit_status );
  gtk_container_add( GTK_CONTAINER(button), psk31_gui.xmit_status );
  g_object_set_data_full( G_OBJECT(psk31_gui.window), "psk31_xmit_status",
      g_object_ref(psk31_gui.xmit_status), (GDestroyNotify)g_object_unref );

  button = Builder_Get_Object( psk31_gui.window_builder, "psk31_receive" );
  psk31_gui.rcve_status = gtk_label_new( _("RECEIVE") );
  gtk_widget_show( psk31_gui.rcve_status );
  gtk_container_add( GTK_CONTAINER(button), psk31_gui.rcve_status );
  g_object_set_data_full( G_OBJECT(psk31_gui.window), "psk31_receive_status",
      g_object_ref( psk31_gui.rcve_status ), (GDestroyNotify)g_object_unref );

  // Get waterfall size
  GtkAllocation alloc;
  gtk_widget_get_allocation( psk31_wfall.canvas, &alloc );
  if( !Create_Wfall_Pixbuf( &psk31_wfall, &psk31_ifft_data,
        (uint16_t)alloc.width, (uint16_t)alloc.height) )
    Error_Dialog( _("Failed to create pixbuf for waterfall"), HIDE_OK );

  // Get scope size
  gtk_widget_get_allocation( psk31_gui.psk31_scope, &alloc );
  psk31_gui.psk31_scope_width  = (uint16_t)alloc.width;
  psk31_gui.psk31_scope_height = (uint16_t)alloc.height;

  // Create the popup menu
  psk31_gui.popup_menu = Psk31_Popup_Menu( &psk31_gui.popup_menu_builder );

  // Prepare data for Rx Print_Character()
  rx_print_chr.text_view     = psk31_gui.rx_text_view;
  rx_print_chr.text_buffer   = psk31_gui.rx_text_buffer;
  rx_print_chr.rx_mode       = True;

  // Set up Receive text view
  gtk_text_buffer_get_iter_at_offset(
      psk31_gui.rx_text_buffer, &psk31_gui.rx_text_buffer_iter, 0 );
  rx_print_chr.iter = &psk31_gui.rx_text_buffer_iter;

  // Prepare data for Tx Print_Character()
  tx_print_chr.text_view     = psk31_gui.tx_text_view;
  tx_print_chr.text_buffer   = psk31_gui.tx_text_buffer;
  tx_print_chr.rx_mode       = False;

  // Set up Transmit text view
  gtk_text_buffer_get_iter_at_offset(
      psk31_gui.tx_text_buffer, &psk31_gui.tx_text_buffer_iter, 0 );
  tx_print_chr.iter = &psk31_gui.tx_text_buffer_iter;

  // Load runtime config file, abort on error
  g_idle_add( Psk31_Read_Config, NULL );

  // Default mode is BPSK
  Flag[PSK31_MODE_BPSK]     = True;
  Flag[PSK31_MODE_QPSK_USB] = False;
  Flag[PSK31_MODE_QPSK_LSB] = False;
  Flag[PSK31_ENABLE_AFC]    = True;
  Flag[GUEST_QUIT]          = False;

  return( psk31_gui.window );
} // Create_Psk31_Window()

//------------------------------------------------------------------

/* Psk31_Popup_Menu()
 *
 * Creates the PSK31 popup menu
 */
  GtkWidget *
Psk31_Popup_Menu( GtkBuilder **builder )
{
  gchar *object_ids[] = { PSK31_POPUP_MENU_IDS };
  Gtk_Builder( builder, psk31_rc.psk31_glade, object_ids );
  GtkWidget *menu = Builder_Get_Object( *builder, "psk31_popup_menu" );
  return( menu );
}

//------------------------------------------------------------------

