/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "display.h"
#include "shared.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include <gtk/gtk.h>

//------------------------------------------------------------------------

// Receive and Transmit status indicators
#define RECV_BPSK     _("<span background=\"green\" foreground=\"white\"> RECEIVE (BPSK) </span>")
#define RECV_QPSK_USB _("<span background=\"green\" foreground=\"white\"> RECEIVE (QPSK-USB) </span>")
#define RECV_QPSK_LSB _("<span background=\"green\" foreground=\"white\"> RECEIVE (QPSK-LSB) </span>")

#define XMIT_BPSK     _("<span background=\"red\" foreground=\"white\"> TRANSMIT (BPSK) </span>")
#define XMIT_QPSK_USB _("<span background=\"red\" foreground=\"white\"> TRANSMIT (QPSK-USB) </span>")
#define XMIT_QPSK_LSB _("<span  background=\"red\" foreground=\"white\"> TRANSMIT (QPSK-LSB) </span>")

//------------------------------------------------------------------------

/* Psk31_Set_TxRx_Labels()
 *
 * Sets up the labels in the Tx/Rx frames
 */
  gboolean
Psk31_Set_TxRx_Labels( gpointer data )
{
  if( Flag[GUEST_TRANSMIT_MODE] )
  {
    if( Flag[PSK31_MODE_BPSK] )
      gtk_label_set_markup( GTK_LABEL(psk31_gui.xmit_status), XMIT_BPSK );
    else if( Flag[PSK31_MODE_QPSK_USB] )
      gtk_label_set_markup( GTK_LABEL(psk31_gui.xmit_status), XMIT_QPSK_USB );
    else if( Flag[PSK31_MODE_QPSK_LSB] )
      gtk_label_set_markup( GTK_LABEL(psk31_gui.xmit_status), XMIT_QPSK_LSB );
  }
  else gtk_label_set_text( GTK_LABEL(psk31_gui.xmit_status),  XMIT_OFF );

  if( Flag[GUEST_RECEIVE_MODE] )
  {
    if( Flag[PSK31_MODE_BPSK] )
      gtk_label_set_markup( GTK_LABEL(psk31_gui.rcve_status), RECV_BPSK );
    else if( Flag[PSK31_MODE_QPSK_USB] )
      gtk_label_set_markup( GTK_LABEL(psk31_gui.rcve_status), RECV_QPSK_USB );
    else if( Flag[PSK31_MODE_QPSK_LSB] )
      gtk_label_set_markup( GTK_LABEL(psk31_gui.rcve_status), RECV_QPSK_LSB );
  }
  else gtk_label_set_text( GTK_LABEL(psk31_gui.rcve_status),  RECV_OFF );

  return( FALSE );
} // Psk31_Set_TxRx_Labels()

//------------------------------------------------------------------------

