/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef PSK31_CALLBACKS_H
#define PSK31_CALLBACKS_H     1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

// callbacks.c
void on_psk31_window_destroy(GObject *object, gpointer user_data);
gboolean on_psk31_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_psk31_tx_textview_key_press(GtkWidget *widget, const GdkEventKey *event, gpointer user_data);
gboolean on_psk31_tx_textview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
gboolean on_psk31_rx_textview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_psk31_squelch_value_changed(GtkRange *range, gpointer user_data);
void on_psk31_op_name_changed(GtkEditable *editable, gpointer user_data);
void on_psk31_qth_name_changed(GtkEditable *editable, gpointer user_data);
void on_psk31_locator_changed(GtkEditable *editable, gpointer user_data);
void on_psk31_band_changed(GtkEditable *editable, gpointer user_data);
void on_psk31_callsign_changed(GtkEditable *editable, gpointer user_data);
void on_psk31_rst_out_changed(GtkEditable *editable, gpointer user_data);
void on_psk31_rst_in_changed(GtkEditable *editable, gpointer user_data);
void on_psk31_new_record_clicked(GtkButton *button, gpointer user_data);
void on_psk31_save_record_clicked(GtkButton *button, gpointer user_data);
void on_psk31_clear_fields_clicked(GtkButton *button, gpointer user_data);
void on_psk31_save_dialog_destroy(GObject *object, gpointer user_data);
void on_psk31_cancel_save_clicked(GtkButton *button, gpointer user_data);
void on_psk31_save_ok_clicked(GtkButton *button, gpointer user_data);
void on_psk31_bpsk_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_psk31_qpsk_lsb_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_psk31_qpsk_usb_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_psk31_capitalize_letters_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_psk31_quit_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_psk31_record_qsos_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_psk31_identify_in_cw_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_psk31_clear_window_activate(GtkMenuItem *menuitem, gpointer user_data);
gboolean on_psk31_scope_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_psk31_wfall_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_psk31_wfall_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_psk31_clear_windows_clicked(GtkButton *button, gpointer user_data);
void on_psk31_freq_adjust_value_changed(GtkRange *range, gpointer user_data);
void on_psk31_transmit_clicked(GtkButton *button, gpointer user_data);
void on_psk31_receive_clicked(GtkButton *button, gpointer user_data);
void on_psk31_macro_clicked(GtkButton *button, gpointer user_data);
void on_psk31_afc_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);

#endif

