/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef STRUC_H
#define STRUC_H     1

#include "../common/common.h"
#include <stdint.h>

//----------------------------------------------------------------------

typedef struct _SEQ
{

  uint32_t Space; // That many elements are allocated in *Elem
  uint32_t Len;   // That many elements are used up
  double  *Elem;  // The storage space, contains Len elements

  // User callable init
  void (*Init)(struct _SEQ *Self);

  // Free all allocated space, remove all data
  void (*Free)(struct _SEQ *Self);

  // Make sure that there is enough space
  BOOLEAN (*EnsureSpace)(struct _SEQ *Self, uint32_t);

  // Delete Num elements at Pos
  void (*Delete)(struct _SEQ *Self, uint32_t, uint32_t );

} Seq_t;

extern void Seq_Initialize( Seq_t *Self );

//----------------------------------------------------------------------

#endif

