/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "struc.h"
#include "../common/utils.h"
#include <stdint.h>
#include <stdlib.h>

//----------------------------------------------------------------------

  static void
Seq_Init( Seq_t *Self )
{
  Self->Elem  = NULL;
  Self->Len   = 0;
  Self->Space = 0;
}

//----------------------------------------------------------------------

  static void
Seq_Free( Seq_t *Self )
{
  Mem_Free( (void **) &Self->Elem );
  Self->Space = 0;
  Self->Len   = 0;
}

//----------------------------------------------------------------------

  static BOOLEAN
Seq_EnsureSpace( Seq_t *Self, uint32_t ReqSpace )
{
  if( ReqSpace <= Self->Space ) return( False );

  Mem_Realloc( (void **) &Self->Elem, (size_t)ReqSpace * sizeof(double) );

  if( Self->Elem == NULL )
  {
    Self->Space = 0;
    Self->Len   = 0;
    return( False );
  }

  Self->Space = ReqSpace;
  return( True );
}

//----------------------------------------------------------------------

  static void
Seq_Delete( Seq_t *Self, uint32_t Pos, uint32_t Num )
{
  if( Self->Len > (Pos + Num) )
    memmove(
        Self->Elem + Pos,
        Self->Elem + Pos + Num,
        ( Self->Len - (Pos + Num) ) * sizeof(double) );
  Self->Len -= Num;
}

//----------------------------------------------------------------------

// Initializes Seq_t structure - my function
  void
Seq_Initialize( Seq_t *Self )
{
  Self->Init = Seq_Init;
  Self->Free = Seq_Free;
  Self->EnsureSpace = Seq_EnsureSpace;
  Self->Delete = Seq_Delete;

  Seq_Init( Self );
}

//----------------------------------------------------------------------

