/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef OLIVIA_SHARED_H
#define OLIVIA_SHARED_H    1

#include "mfsk.h"
#include "../common/common.h"
#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include "../common/utils.h"
#include <gtk/gtk.h>

//------------------------------------------------------------------------

// MFSK Receiver object
extern MFSK_Receiver_t Receiver;

// MFSK Transmitter object
extern MFSK_Transmitter_t Transmitter;

// Configuration parameters structure
typedef struct _OLIVIA_RC_DATA
{
  uint8_t
    mode,           // Olivia mode
    sync_integ_len, // Receiver synchronizer integration length
    sync_margin,    // Receiver synchronizer search margin
    word_wrap;      // Word wrap column number

  double sync_threshold;  // Receiver sync detection threshold

  char
    olivia_glade[FILE_NAME_SIZE],  // Olivia glade file path
    rc_fpath[FILE_NAME_SIZE];      // File path to oliviarc

  BOOLEAN mode_olivia;   // TRUE = Mode is Olivia - FALSE = Mode is Contestia

} olivia_rc_data_t;

// Runtime config data
extern olivia_rc_data_t olivia_rc_data;

// MFSK parameters structure
extern MFSK_Parameters_t Olivia_Parameters;

//------------------------------------------------------------------------

// Olivia GUI widgets
typedef struct _OLIVIA_GUI
{
  GtkWidget
    *window,
    *popup_menu,
    *xmit_status,
    *rcve_status,
    *tx_monitor_string,
    *tx_input_status,
    *input_snr,
    *sync_snr,
    *freq_offset,
    *char_persec,
    *scope;

  uint16_t scope_width, scope_height;

  // Builder objects for main window and menu
  GtkBuilder *window_builder, *popup_menu_builder;

  // Text viewers
  GtkTextView *rx_text_view, *tx_text_view;

  // Text buffers for text viewers
  GtkTextBuffer *rx_text_buffer,     *tx_text_buffer;
  GtkTextIter    rx_text_buffer_iter, tx_text_buffer_iter;

} olivia_gui_t;

extern olivia_gui_t olivia_gui;

// Olivia waterfall
extern pixbuffer_t olivia_wfall;

// IFFT() data object
extern ifft_data_t olivia_ifft_data;

// Macros attached to F1-F10
extern char *olivia_macro[NUM_OF_LABELS];

//------------------------------------------------------------------------

#endif

