/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"
#include "../common/ifft.h"
#include "../common/guest_utils.h"

//------------------------------------------------------------------------

// MFSK Receiver object
MFSK_Receiver_t Receiver;

// MFSK Transmitter object
MFSK_Transmitter_t Transmitter;

// Runtime config data
olivia_rc_data_t olivia_rc_data;

// MFSK parameters structure
MFSK_Parameters_t Olivia_Parameters;

// Psk31 GUI widgets
olivia_gui_t olivia_gui;

// Psk31 waterfall
pixbuffer_t olivia_wfall;

// Data for the IFFT() function
ifft_data_t olivia_ifft_data;

// Macros attached to F1-F10
char *olivia_macro[NUM_OF_LABELS];

//------------------------------------------------------------------------

