/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef RATECONV_H
#define RATECONV_H    1

#include "struc.h"
#include <stdint.h>
#include <stdlib.h>

//----------------------------------------------------------------------

// Rate converter, to correct for the soundcard sampling rate
typedef struct _CRATECONVERTER
{
  // Parameters to be set by the user
  uint32_t TapLen;        // Filter tap length ( in term of input samples )
  uint32_t OverSampling;  // Internal oversampling factor
  double   UpperFreq;     // Upper frequency of the ( lowpass ) filter
  double   OutputRate;    // The output rate ( in terms of the input rate )
  uint32_t FilterLen;     // The total length of the filter ( in term of oversampled rate )
  double  *FilterShape;   // The shape of the filter
  double  *InputTap;      // Filter tap
  uint32_t InputTapPtr;
  uint32_t InputWrap;

  double   OutputTime;
  double   OutputPeriod;
  double   OutputBefore;
  double   OutputAfter;
  uint32_t OutputPtr;

  // Pointers to functions that were in class CRateConverter
  void   (*Init)(struct _CRATECONVERTER *);
  void   (*Free)(struct _CRATECONVERTER *);
  void   (*Default)(struct _CRATECONVERTER *);
  void   (*Preset)(struct _CRATECONVERTER *);
  void   (*Reset)(struct _CRATECONVERTER *);
  double (*Convolute)(struct _CRATECONVERTER *, size_t);
  void   (*NewInput)(struct _CRATECONVERTER *, double);
  int    (*Process)(struct _CRATECONVERTER *, double *, uint32_t, double *);
  int    (*Process_Seq)(struct _CRATECONVERTER *, double *, uint32_t, Seq_t *);

} CRateConverter_t;

extern void CRateConverter_Initialize(CRateConverter_t *);

//----------------------------------------------------------------------

#endif

