/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef LOWPASS3_H
#define LOWPASS3_H    1

#include <stdint.h>

//----------------------------------------------------------------------

typedef struct _LOWPASS3_FILTER
{
  double Out1, Out2, Output;

  // Pointers to functions that were in class LowPass3_Filter
  void (*Init)(struct _LOWPASS3_FILTER *);
  void (*Process)(struct _LOWPASS3_FILTER *, double, double, double);
  void (*Set)(struct _LOWPASS3_FILTER *, double);

} LowPass3_Filter_t;


extern void LowPass3_Filter_Initialize(LowPass3_Filter_t *);

//-----------------------------------------------------------------------

// A circular buffer to store history of LowPass3_Filter
// type data. Data may come as single numbers or in batches
// of fixed size (-> Width )
typedef struct _CIRCULARBUFFER_FILTER
{
  uint32_t Width;  // Input/output data width ( row width )
  uint32_t Len;    // Buffer length ( column height )
  uint32_t Size;   // Total size of the storage in the buffer
  uint32_t Ptr;    // Current pointer ( counts rows )
  LowPass3_Filter_t *Data; // Allocated storage

  // Pointers to functions that were in class CircularBuffer
  void (*Init)(struct _CIRCULARBUFFER_FILTER *);
  void (*Free)(struct _CIRCULARBUFFER_FILTER *);
  void (*Preset)(struct _CIRCULARBUFFER_FILTER *);
  void (*Clear)(struct _CIRCULARBUFFER_FILTER *);
  void (*IncrPtr)(const struct _CIRCULARBUFFER_FILTER *, uint32_t *, uint32_t);
  void (*DecrPtr)(const struct _CIRCULARBUFFER_FILTER *, uint32_t *, uint32_t);
  void (*WrapPhase)(struct _CIRCULARBUFFER_FILTER *, double *);
  void (*WrapDiffPhase)(struct _CIRCULARBUFFER_FILTER *, double *);
  void (*Reset)(struct _CIRCULARBUFFER_FILTER *);
  void (*PresetNew)(struct _CIRCULARBUFFER_FILTER *, uint32_t, uint32_t);
  void (*Set)(struct _CIRCULARBUFFER_FILTER *, double *);
  LowPass3_Filter_t * (*CurrPtr)(const struct _CIRCULARBUFFER_FILTER *);
  LowPass3_Filter_t * (*OffsetPtr)(struct _CIRCULARBUFFER_FILTER *, int);

} CircularBuffer_Filter_t;

extern void CircularBuffer_Filter_Initialize(CircularBuffer_Filter_t *);

//----------------------------------------------------------------------

#endif

