/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */
#include "interface.h"
#include "display.h"
#include "mfsk.h"
#include "operation.h"
#include "shared.h"
#include "utils.h"
#include "../common/common.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include <gtk/gtk.h>
#include <stdint.h>
#include <stdlib.h>

//------------------------------------------------------------------

#define OLIVIA_WINDOW_IDS \
  "olivia_window", \
  NULL

//------------------------------------------------------------------

/* Create_Olivia_Window()
 *
 * Creates the main window for OLIVIA
 */
  GtkWidget *
Create_Olivia_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { OLIVIA_WINDOW_IDS };

  // Default mode is Olivia 8/250
  Flag[OLIVIA_MODE_4_125]    = False;
  Flag[OLIVIA_MODE_4_250]    = False;
  Flag[OLIVIA_MODE_8_250]    = True;
  Flag[OLIVIA_MODE_8_500]    = False;
  Flag[OLIVIA_MODE_16_500]   = False;
  Flag[OLIVIA_MODE_16_1000]  = False;
  Flag[OLIVIA_MODE_32_1000]  = False;
  Flag[GUEST_QUIT]           = False;
  olivia_rc_data.mode_olivia = True;

  // Initialize Digimode and DUC Send semaphore
  if( !Init_Semaphore(&digimode_semaphore, True) )
    return( NULL );
  if( !Init_Semaphore(&duc_send_semaphore, True) )
    return( NULL );
  xmit_buffer.xmit_buf_i = NULL;
  xmit_buffer.xmit_buf_q = NULL;

  // Create the olivia glade file name
  Strlcpy( olivia_rc_data.olivia_glade,
      getenv("HOME"), sizeof(olivia_rc_data.olivia_glade) );
  Strlcat( olivia_rc_data.olivia_glade,
      "/.hermes2/olivia/olivia.glade", sizeof(olivia_rc_data.olivia_glade) );

  // Create olivia main window
  Gtk_Builder( builder, olivia_rc_data.olivia_glade, object_ids );
  olivia_gui.window = Builder_Get_Object( *builder, "olivia_window" );

  // Get Rx text buffer
  olivia_gui.rx_text_view =
    GTK_TEXT_VIEW( Builder_Get_Object(olivia_gui.window_builder, "olivia_rx_textview") );
  olivia_gui.rx_text_buffer = gtk_text_view_get_buffer( olivia_gui.rx_text_view );

  // Get Tx text buffer
  olivia_gui.tx_text_view =
    GTK_TEXT_VIEW( Builder_Get_Object(olivia_gui.window_builder, "olivia_tx_textview") );
  olivia_gui.tx_text_buffer = gtk_text_view_get_buffer( olivia_gui.tx_text_view );

  // Prepare data for Rx Queue_Character()
  gtk_text_buffer_get_iter_at_offset(
      olivia_gui.rx_text_buffer, &olivia_gui.rx_text_buffer_iter, 0 );
  rx_print_chr.iter          = &( olivia_gui.rx_text_buffer_iter );
  rx_print_chr.text_view     = olivia_gui.rx_text_view;
  rx_print_chr.text_buffer   = olivia_gui.rx_text_buffer;
  rx_print_chr.rx_mode       = True;

  // Prepare data for Tx Queue_Character()
  tx_print_chr.text_view     = olivia_gui.tx_text_view;
  tx_print_chr.text_buffer   = olivia_gui.tx_text_buffer;
  tx_print_chr.rx_mode       = False;

  // Get Monitor, Input SNR, Sync SNR, Freq Offset, Speed text entries
  olivia_gui.tx_monitor_string =
    Builder_Get_Object( olivia_gui.window_builder, "tx_monitor_string" );
  Enter_Tx_Monitor_Char( 0xFF ); // Clears monitor string
  olivia_gui.tx_input_status =
    Builder_Get_Object( olivia_gui.window_builder, "tx_input_status" );
  olivia_gui.input_snr   = Builder_Get_Object( olivia_gui.window_builder, "input_snr" );
  olivia_gui.sync_snr    = Builder_Get_Object( olivia_gui.window_builder, "sync_snr" );
  olivia_gui.freq_offset = Builder_Get_Object( olivia_gui.window_builder, "freq_offset" );
  olivia_gui.char_persec = Builder_Get_Object( olivia_gui.window_builder, "char_persec" );

  // Get scope widget
  olivia_gui.scope = Builder_Get_Object( olivia_gui.window_builder, "olivia_scope" );

  // Get waterfall widget
  olivia_wfall.canvas = Builder_Get_Object(olivia_gui.window_builder, "olivia_wfall" );

  // Set labels to Xmit and Rcve buttons
  GtkWidget *button =
    Builder_Get_Object( olivia_gui.window_builder, "olivia_transmit" );
  olivia_gui.xmit_status = gtk_label_new( _("TRANSMIT") );
  gtk_widget_show( olivia_gui.xmit_status );
  gtk_container_add( GTK_CONTAINER(button), olivia_gui.xmit_status );
  g_object_set_data_full( G_OBJECT(olivia_gui.window), "olivia_xmit_status",
      g_object_ref(olivia_gui.xmit_status), (GDestroyNotify)g_object_unref );

  button = Builder_Get_Object( olivia_gui.window_builder, "olivia_receive" );
  olivia_gui.rcve_status = gtk_label_new( _("RECEIVE") );
  gtk_widget_show( olivia_gui.rcve_status );
  gtk_container_add( GTK_CONTAINER(button), olivia_gui.rcve_status );
  g_object_set_data_full( G_OBJECT(olivia_gui.window), "olivia_receive_status",
      g_object_ref( olivia_gui.rcve_status ), (GDestroyNotify)g_object_unref );

  // Get waterfall size
  GtkAllocation alloc;
  gtk_widget_get_allocation( olivia_wfall.canvas, &alloc );
  if( !Create_Wfall_Pixbuf( &olivia_wfall, &olivia_ifft_data,
        (uint16_t)alloc.width, (uint16_t)alloc.height) )
    Error_Dialog( _("Failed to create pixbuf for waterfall"), HIDE_OK );

  // Get scope size
  gtk_widget_get_allocation( olivia_gui.scope, &alloc );
  olivia_gui.scope_width  = (uint16_t)alloc.width;
  olivia_gui.scope_height = (uint16_t)alloc.height;

  // Create the popup menu
  olivia_gui.popup_menu = Olivia_Popup_Menu( &olivia_gui.popup_menu_builder );

  // Load runtime config file, abort on error
  g_idle_add( Olivia_Read_Config, NULL );

  return( olivia_gui.window );
} // Create_Olivia_Window()

//------------------------------------------------------------------

/* Olivia_Popup_Menu()
 *
 * Creates the OLIVIA popup menu
 */
  GtkWidget *
Olivia_Popup_Menu( GtkBuilder **builder )
{
  gchar *object_ids[] = { OLIVIA_POPUP_MENU_IDS };
  Gtk_Builder( builder, olivia_rc_data.olivia_glade, object_ids );
  GtkWidget *menu = Builder_Get_Object( *builder, "olivia_popup_menu" );
  return( menu );
}

//------------------------------------------------------------------

