/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "fht.h"
#include <stdint.h>

// Fast Hadamard Transform, Pawel Jalocha, December 2004

// Forward Fast Hadamard Transform
  void
FHT_Int8( int8_t *Data, uint32_t Len )
{
  uint32_t Step, Ptr, Ptr2;
  int8_t   Bit1, Bit2, NewBit1, NewBit2;

  for( Step = 1; Step < Len; Step *= 2 )
  {
    for( Ptr = 0; Ptr < Len; Ptr += 2 * Step )
    {
      for( Ptr2 = Ptr; (Ptr2 - Ptr ) < Step; Ptr2++ )
      {
        Bit1 = Data[Ptr2];
        Bit2 = Data[Ptr2 + Step];
        NewBit1  = Bit2 + Bit1;
        NewBit2  = Bit2 - Bit1;
        Data[Ptr2] = NewBit1;
        Data[Ptr2 + Step] = NewBit2;
      }
    }
  }
}

//----------------------------------------------------------------------

// Inverse Fast Hadamard Transform
  void
IFHT_Int8( int8_t *Data, uint32_t Len )
{
  uint32_t Step, Ptr, Ptr2;
  int8_t   Bit1, Bit2, NewBit1, NewBit2;

  for( Step = Len / 2; Step; Step /= 2 )
  {
    for( Ptr = 0; Ptr < Len; Ptr += 2 * Step )
    {
      for( Ptr2 = Ptr; (Ptr2 - Ptr ) < Step; Ptr2++ )
      {
        Bit1 = Data[Ptr2];
        Bit2 = Data[Ptr2+Step];
        NewBit1  = Bit1 - Bit2;
        NewBit2  = Bit1 + Bit2;
        Data[Ptr2] = NewBit1;
        Data[Ptr2 + Step] = NewBit2;
      }
    }
  }
}

//----------------------------------------------------------------------

// Forward Fast Hadamard Transform
  void
FHT_Float( double *Data, uint32_t Len )
{
  uint32_t Step, Ptr, Ptr2;
  double   Bit1, Bit2, NewBit1, NewBit2;

  for( Step = 1; Step < Len; Step *= 2 )
  {
    for( Ptr = 0; Ptr < Len; Ptr += 2 * Step )
    {
      for( Ptr2 = Ptr; (Ptr2 - Ptr ) < Step; Ptr2++ )
      {
        Bit1 = Data[Ptr2];
        Bit2 = Data[Ptr2 + Step];
        NewBit1  = Bit2 + Bit1;
        NewBit2  = Bit2 - Bit1;
        Data[Ptr2] = NewBit1;
        Data[Ptr2 + Step] = NewBit2;
      }
    }
  }
}

//----------------------------------------------------------------------

// Inverse Fast Hadamard Transform
  void
IFHT_Float( double *Data, uint32_t Len )
{
  uint32_t Step, Ptr, Ptr2;
  double   Bit1, Bit2, NewBit1, NewBit2;

  for( Step = Len / 2; Step; Step /= 2 )
  {
    for( Ptr = 0; Ptr < Len; Ptr += 2 * Step )
    {
      for( Ptr2 = Ptr; (Ptr2 - Ptr ) < Step; Ptr2++ )
      {
        Bit1 = Data[Ptr2];
        Bit2 = Data[Ptr2+Step];
        NewBit1  = Bit1 - Bit2;
        NewBit2  = Bit1 + Bit2;
        Data[Ptr2] = NewBit1;
        Data[Ptr2 + Step] = NewBit2;
      }
    }
  }
}

//----------------------------------------------------------------------

