/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "display.h"
#include "shared.h"
#include "../common/guest_utils.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include "../hpsdr/settings.h"
#include <gtk/gtk.h>

//------------------------------------------------------------------------

// Receive and Transmit status indicators
#define OLV_RECV_4_125    _("<span background=\"green\" foreground=\"white\"> OLIVIA 4/125 </span>")
#define OLV_RECV_4_250    _("<span background=\"green\" foreground=\"white\"> OLIVIA 4/250 </span>")
#define OLV_RECV_8_250    _("<span background=\"green\" foreground=\"white\"> OLIVIA 8/250 </span>")
#define OLV_RECV_8_500    _("<span background=\"green\" foreground=\"white\"> OLIVIA 8/500 </span>")
#define OLV_RECV_16_500   _("<span background=\"green\" foreground=\"white\"> OLIVIA 16/500 </span>")
#define OLV_RECV_16_1000  _("<span background=\"green\" foreground=\"white\"> OLIVIA 16/1000 </span>")
#define OLV_RECV_32_1000  _("<span background=\"green\" foreground=\"white\"> OLIVIA 32/1000 </span>")
#define CON_RECV_4_125    _("<span background=\"green\" foreground=\"white\"> CONTESTIA 4/125 </span>")
#define CON_RECV_4_250    _("<span background=\"green\" foreground=\"white\"> CONTESTIA 4/250 </span>")
#define CON_RECV_8_250    _("<span background=\"green\" foreground=\"white\"> CONTESTIA 8/250 </span>")
#define CON_RECV_8_500    _("<span background=\"green\" foreground=\"white\"> CONTESTIA 8/500 </span>")
#define CON_RECV_16_500   _("<span background=\"green\" foreground=\"white\"> CONTESTIA 16/500 </span>")
#define CON_RECV_16_1000  _("<span background=\"green\" foreground=\"white\"> CONTESTIA 16/1000 </span>")
#define CON_RECV_32_1000  _("<span background=\"green\" foreground=\"white\"> CONTESTIA 32/1000 </span>")

#define OLV_XMIT_4_125    _("<span background=\"red\" foreground=\"white\"> OLIVIA 4/125 </span>")
#define OLV_XMIT_4_250    _("<span background=\"red\" foreground=\"white\"> OLIVIA 4/250 </span>")
#define OLV_XMIT_8_250    _("<span background=\"red\" foreground=\"white\"> OLIVIA 8/250 </span>")
#define OLV_XMIT_8_500    _("<span background=\"red\" foreground=\"white\"> OLIVIA 8/500 </span>")
#define OLV_XMIT_16_500   _("<span background=\"red\" foreground=\"white\"> OLIVIA 16/500 </span>")
#define OLV_XMIT_16_1000  _("<span background=\"red\" foreground=\"white\"> OLIVIA 16/1000 </span>")
#define OLV_XMIT_32_1000  _("<span background=\"red\" foreground=\"white\"> OLIVIA 32/1000 </span>")
#define CON_XMIT_4_125    _("<span background=\"red\" foreground=\"white\"> CONTESTIA 4/125 </span>")
#define CON_XMIT_4_250    _("<span background=\"red\" foreground=\"white\"> CONTESTIA 4/250 </span>")
#define CON_XMIT_8_250    _("<span background=\"red\" foreground=\"white\"> CONTESTIA 8/250 </span>")
#define CON_XMIT_8_500    _("<span background=\"red\" foreground=\"white\"> CONTESTIA 8/500 </span>")
#define CON_XMIT_16_500   _("<span background=\"red\" foreground=\"white\"> CONTESTIA 16/500 </span>")
#define CON_XMIT_16_1000  _("<span background=\"red\" foreground=\"white\"> CONTESTIA 16/1000 </span>")
#define CON_XMIT_32_1000  _("<span background=\"red\" foreground=\"white\"> CONTESTIA 32/1000 </span>")

//------------------------------------------------------------------------

/* Olivia_Set_TxRx_Labels()
 *
 * Sets up the labels in the Tx/Rx frames
 */
  gboolean
Olivia_Set_TxRx_Labels( gpointer data )
{
  if( olivia_rc_data.mode_olivia )
  {
    if( Flag[GUEST_TRANSMIT_MODE] )
    {
      if( Flag[OLIVIA_MODE_4_125] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), OLV_XMIT_4_125 );
      else if( Flag[OLIVIA_MODE_4_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), OLV_XMIT_4_250 );
      else if( Flag[OLIVIA_MODE_8_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), OLV_XMIT_8_250 );
      else if( Flag[OLIVIA_MODE_8_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), OLV_XMIT_8_500 );
      else if( Flag[OLIVIA_MODE_16_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), OLV_XMIT_16_500 );
      else if( Flag[OLIVIA_MODE_16_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), OLV_XMIT_16_1000 );
      else if( Flag[OLIVIA_MODE_32_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), OLV_XMIT_32_1000 );
    }
    else gtk_label_set_text( GTK_LABEL(olivia_gui.xmit_status),  XMIT_OFF );
  } // if( olivia_rc_data.mode_olivia )
  else
  {
    if( Flag[GUEST_TRANSMIT_MODE] )
    {
      if( Flag[OLIVIA_MODE_4_125] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), CON_XMIT_4_125 );
      else if( Flag[OLIVIA_MODE_4_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), CON_XMIT_4_250 );
      else if( Flag[OLIVIA_MODE_8_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), CON_XMIT_8_250 );
      else if( Flag[OLIVIA_MODE_8_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), CON_XMIT_8_500 );
      else if( Flag[OLIVIA_MODE_16_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), CON_XMIT_16_500 );
      else if( Flag[OLIVIA_MODE_16_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), CON_XMIT_16_1000 );
      else if( Flag[OLIVIA_MODE_32_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.xmit_status), CON_XMIT_32_1000 );
    }
    else gtk_label_set_text( GTK_LABEL(olivia_gui.xmit_status),  XMIT_OFF );
  } // if( olivia_rc_data.mode_olivia )

  if( olivia_rc_data.mode_olivia )
  {
    if( Flag[GUEST_RECEIVE_MODE] )
    {
      if( Flag[OLIVIA_MODE_4_125] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), OLV_RECV_4_125 );
      else if( Flag[OLIVIA_MODE_4_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), OLV_RECV_4_250 );
      else if( Flag[OLIVIA_MODE_8_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), OLV_RECV_8_250 );
      else if( Flag[OLIVIA_MODE_8_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), OLV_RECV_8_500 );
      else if( Flag[OLIVIA_MODE_16_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), OLV_RECV_16_500 );
      else if( Flag[OLIVIA_MODE_16_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), OLV_RECV_16_1000 );
      else if( Flag[OLIVIA_MODE_32_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), OLV_RECV_32_1000 );
    }
    else gtk_label_set_text( GTK_LABEL(olivia_gui.rcve_status),  RECV_OFF );
  } // if( olivia_rc_data.mode_olivia )
  else
  {
    if( Flag[GUEST_RECEIVE_MODE] )
    {
      if( Flag[OLIVIA_MODE_4_125] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), CON_RECV_4_125 );
      else if( Flag[OLIVIA_MODE_4_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), CON_RECV_4_250 );
      else if( Flag[OLIVIA_MODE_8_250] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), CON_RECV_8_250 );
      else if( Flag[OLIVIA_MODE_8_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), CON_RECV_8_500 );
      else if( Flag[OLIVIA_MODE_16_500] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), CON_RECV_16_500 );
      else if( Flag[OLIVIA_MODE_16_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), CON_RECV_16_1000 );
      else if( Flag[OLIVIA_MODE_32_1000] )
        gtk_label_set_markup( GTK_LABEL(olivia_gui.rcve_status), CON_RECV_32_1000 );
    }
    else gtk_label_set_text( GTK_LABEL(olivia_gui.rcve_status),  RECV_OFF );
  } // if( olivia_rc_data.mode_olivia )

  return( FALSE );
} // Olivia_Set_TxRx_Labels()

//------------------------------------------------------------------------

/* Olivia_Show_Decoder_Status()
 *
 * Sets the Decoder's status (Input SNR, Sync SNR and Freq Offset)
 * to the relevant text entry widgets.
 */
  gboolean
Olivia_Show_Decoder_Status( gpointer data )
{
  gchar txt[10];

  // Input Signal/Noise ratio
  snprintf( txt, sizeof(txt), "%5.1f", Receiver.InputSNRdB() );
  if( strstr(txt, "nan") != NULL )
    gtk_entry_set_text( GTK_ENTRY(olivia_gui.input_snr), "- - -" );
  else
    gtk_entry_set_text( GTK_ENTRY(olivia_gui.input_snr), txt );

  // Synchronizer Signal/Noise ratio
  snprintf( txt, sizeof(txt), "%5.1f", Receiver.SyncSNR() );
  gtk_entry_set_text( GTK_ENTRY(olivia_gui.sync_snr), txt );

  // Characters per second
  snprintf( txt, sizeof(txt), "%3.1f",
      Olivia_Parameters.CharactersPerSecond(&Olivia_Parameters) );
  gtk_entry_set_text( GTK_ENTRY(olivia_gui.char_persec), txt );

  // Frequency offset calculated by Olivia Synchronizer
  double offset = Receiver.FrequencyOffset();
  snprintf( txt, sizeof(txt), "%5.1f", offset );
  gtk_entry_set_text( GTK_ENTRY(olivia_gui.freq_offset), txt );

  // Add frequency offset to Tuner Frequency to correct
  if( Flag[OLIVIA_TUNE_OFFSET] )
  {
    Flag[OLIVIA_TUNE_OFFSET] = False;
    Transceiver_t *TRx = Transceiver[Indices.TRx_Index];
    int rx_freq = (int)TRx->rx_frequency;
    rx_freq += (int)( offset + 0.5 );
    if( rx_freq < 0 ) rx_freq = 0;
    TRx->rx_frequency = (uint32_t)rx_freq;
    Hermes2_Set_Center_Frequency( TRx, RX_FLAG );

    // Link Tx frequency to Rx
    if( TRx->link_tx_rx_freq && !TRx->tx_freq_lock )
    {
      TRx->tx_frequency = (uint32_t)rx_freq;
      Hermes2_Set_Center_Frequency( TRx, TX_FLAG );
    }
  }

  return( FALSE );
} // Olivia_Show_Decoder_Status()

//------------------------------------------------------------------------

// Points to plot
static GdkPoint *points = NULL;

/* Olivia_Display_Scope()
 *
 * Displays amplitude of the FFT Spectrum bins and draws
 * the verical and horizontal reticle lines, in response
 * to the draw event for the Spectrum Monitors drawingarea
 */
  void
Olivia_Display_Scope(
    GtkWidget *widget,
    cairo_t *cr,
    ifft_data_t *ifft_data )
{
  static uint32_t points_idx = 0;

  GdkDrawingContext *gdc;
  GdkWindow *window;

  // Index to fft output array
  uint32_t fft_idx, idx;

  // Initialize on first call
  if( points == NULL )
    Mem_Alloc( (void **) &points, ifft_data->ifft_width * sizeof(GdkPoint) );

  // Initialize drawing
  window = gtk_widget_get_window( widget );
  cairo_region_t *region = cairo_region_create();
  gdc = gdk_window_begin_draw_frame( window, region );
  cairo_region_destroy( region );
  cairo_set_line_join( cr, CAIRO_LINE_JOIN_ROUND );
  cairo_set_line_cap(  cr, CAIRO_LINE_CAP_ROUND );

  // Save values to be plotted (scaled to fit display)
  points_idx   = 0;
  for( fft_idx = 0; fft_idx < olivia_gui.scope_width; fft_idx++ )
  {
    // Even input array locations contain ifft bins
    points[points_idx].y = olivia_gui.scope_height - ifft_data->ifft_bins[fft_idx];
    if( points[points_idx].y < 0 ) points[points_idx].y = 0;
    points[points_idx].x = (gint)points_idx;
    points_idx++;
  } // for( fft_idx = 0; fft_idx < ... )

  // Draw signal background
  cairo_set_source_rgb( cr, SCOPE_BACKGND );
  cairo_rectangle( cr, 0.0, 0.0,
      (double)olivia_gui.scope_width, (double)olivia_gui.scope_height );
  cairo_fill( cr );

  // Plot signal graph
  cairo_set_line_width( cr, 1.5 );
  cairo_set_source_rgb( cr, SCOPE_FOREGND );
  cairo_move_to( cr,
      (double)points[0].x + 0.5,
      (double)points[0].y );
  for( idx = 1; idx < points_idx; idx++ )
    cairo_line_to( cr,
        (double)points[idx].x + 0.5,
        (double)points[idx].y );

  // Stroke paths
  cairo_stroke( cr );

  // Wait for GTK to complete its tasks
  gdk_window_end_draw_frame( window, gdc );

} // Olivia_Display_Scope

//----------------------------------------------------------------------

