/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef OLIVIA_CALLBACKS_H
#define OLIVIA_CALLBACKS_H     1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

// All the callback functions of the Olivia client

// callbacks.c
void on_olivia_window_destroy(GObject *object, gpointer user_data);
void Olivia_g_Idle_cb(gpointer data);
gboolean on_olivia_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_olivia_tx_textview_key_press(GtkWidget *widget, GdkEventKey *event, gpointer user_data);
gboolean on_olivia_tx_textview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
gboolean on_olivia_rx_textview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_olivia_op_name_changed(GtkEditable *editable, gpointer user_data);
void on_olivia_qth_name_changed(GtkEditable *editable, gpointer user_data);
void on_olivia_locator_changed(GtkEditable *editable, gpointer user_data);
void on_olivia_band_changed(GtkEditable *editable, gpointer user_data);
void on_olivia_callsign_changed(GtkEditable *editable, gpointer user_data);
void on_olivia_rst_out_changed(GtkEditable *editable, gpointer user_data);
void on_olivia_rst_in_changed(GtkEditable *editable, gpointer user_data);
void on_olivia_new_record_clicked(GtkButton *button, gpointer user_data);
void on_olivia_save_record_clicked(GtkButton *button, gpointer user_data);
void on_olivia_clear_fields_clicked(GtkButton *button, gpointer user_data);
void on_olivia_save_dialog_destroy(GObject *object, gpointer user_data);
void on_olivia_cancel_save_clicked(GtkButton *button, gpointer user_data);
void on_olivia_save_ok_clicked(GtkButton *button, gpointer user_data);
void on_mode_olivia_toggled(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_4_125_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_4_250_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_8_250_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_8_500_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_16_500_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_16_1000_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_32_1000_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_capitalize_letters_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_quit_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_record_qsos_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_identify_in_cw_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_olivia_clear_window_activate(GtkMenuItem *menuitem, gpointer user_data);
gboolean on_olivia_scope_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_olivia_scope_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
gboolean on_olivia_wfall_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_olivia_wfall_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);void on_olivia_clear_windows_clicked(GtkButton *button, gpointer user_data);
void on_olivia_transmit_clicked(GtkButton *button, gpointer user_data);
void on_olivia_receive_clicked(GtkButton *button, gpointer user_data);
void on_olivia_macro_clicked(GtkButton *button, gpointer user_data);
void on_tune_freq_offset_clicked(GtkButton *button, gpointer user_data);
void on_olivia_flush_clicked(GtkButton *button, gpointer user_data);

#endif

