/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef MORSE_SHARED_H
#define MORSE_SHARED_H   1

#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>
#include <stdint.h>

//-------------------------------------------------------------------

// Demodulator output (audio) sample rate
#define INPUT_SAMPLE_RATE     48000

//-------------------------------------------------------------------

// Runtine configuration data
typedef struct _MORSE_RC
{
  uint16_t
    tone_freq,     // Receiver BFO Tone freq
    center_line,   // Waterfall BFO Tone freq marker line
    speed_wpm,     // Current Morse speed words/min
    max_wpm,       // Maximimum Morse speed words/min
    min_wpm,       // Minimum Morse speed words/min
    unit_elem,     // Morse unit element (dot) length
    min_unit,      // Minimum length of unit element
    max_unit,      // Maximum length of unit element
    max_unit_x2,   // Maximum length of unit element * 2
    det_squelch,   // Squelch level of signal detector
    det_threshold; // Current threshold value of mark/space detector

  // Ratio of lead/trail edge for mark/space detection
  double det_ratio;

  // File path to morse.config
  char rc_fpath[FILE_NAME_SIZE];

} morse_rc_t;

// Runtime config data
extern morse_rc_t morse_rc;

//-------------------------------------------------------------------

// Structure with the data for the Morse client window
typedef struct _MORSE_GUI
{
  // Main window
  GtkWidget *window;
  gint window_x, window_y;

  // Main window builder
  GtkBuilder *window_builder;

  // Global widgets
  GtkWidget
    *scope,
    *scope_label;

  uint16_t
    scope_width,
    scope_height;

  // Speed and squelch spin button
  GtkSpinButton
    *speed_spinbtn,
    *squelch_spinbtn,
    *ratio_spinbtn;

  // Text buffer for text viewer
  GtkTextView   *text_view;
  GtkTextBuffer *text_buffer;

} morse_gui_t;

// Global GUI widgets and data
extern morse_gui_t morse_gui;

//-------------------------------------------------------------------

// Waterfall pix buff
extern pixbuffer_t morse_wfall;

//-------------------------------------------------------------------

// IFFT data object
extern ifft_data_t morse_ifft_data;

//-------------------------------------------------------------------

#endif

