/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef MORSE_CALLBACKS_H
#define MORSE_CALLBACKS_H   1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

//----------------------------------------------------------------------

// callbacks.c
void on_morse_window_destroy(GObject *object, gpointer user_data);
gboolean on_morse_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_morse_scope_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_morse_waterfall_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_morse_waterfall_drawingarea_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_wpm_spinbutton_value_changed(GtkSpinButton *spin_button, gpointer user_data);
void on_morse_squelch_spinbutton_value_changed(GtkSpinButton *spin_button, gpointer user_data);
void on_ratio_spinbutton_value_changed(GtkSpinButton *spin_button, gpointer user_data);
void on_morse_clear_button_clicked(GtkButton *button, gpointer user_data);
void on_morse_auto_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_morse_waterfall_drawingarea_configure(GtkWidget *widget, const GdkEventConfigure *event, gpointer user_data);
void on_morse_receive_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_ratio_radiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_level_radiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_stop_radiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_signal_radiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);

//----------------------------------------------------------------------

#endif

