/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SETTINGS_H
#define SETTINGS_H   1

#include "../common/transceiver.h"
#include <gtk/gtk.h>
#include <stdint.h>

//----------------------------------------------------------------------

/* HL2 Filter settings. Band filters are OUT till selected
 * by the settings below. The 3MHz HPF is IN till bypassed */
#define  LP_FILTER_160M     BIT_1
#define  LP_FILTER_80M      BIT_2
#define  LP_FILTER_60_40M   BIT_3
#define  LP_FILTER_30_20M   BIT_4
#define  LP_FILTER_17_15M   BIT_5
#define  LP_FILTER_12_10M   BIT_6
#define  HP_FILTER_3MHZ     BIT_7  // Bypass HPF 3MHz filter

//----------------------------------------------------------------------

// settings.c
gboolean Hpsdr_Auto_LNA_Gain(gpointer data);
void Hermes2_Set_Center_Frequency(Transceiver_t *TRx, BOOLEAN rx_flag);
void Hpsdr_Set_Sample_Rate(Transceiver_t *TRx);
void Adc_Change_Antenna(uint8_t ant);
void Hpsdr_Set_LNA_Gain(int8_t gain);

//----------------------------------------------------------------------

#endif

