/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef PC_TO_HW_H
#define PC_TO_HW_H  1

#include "../common/transceiver.h"
#include <gtk/gtk.h>
#include <stdint.h>

//----------------------------------------------------------------------

// Number of samples in DUC IQ packet and sample rate S/s
#define DUC_NUM_IQ_SAMPLES   126
#define DUC_SAMPLE_RATE      48000

// Start of DUC IQ data in net buffer
#define DUC_IQ_SAMPLES_START   4

//----------------------------------------------------------------------

// Command Control and Audio IQ Data packet PC to Metis
#define CCD_BUFFER_SIZE     1032

// Number of Cmnd and Ctrl adresses and data bytes
#define CCD_NUM_ADRESSES    27
#define CCD_ADDR_STACK      50
#define CCD_NUM_CC_BYTES    5

// Position of Sequence Number in buffer
#define CCD_SEQ_NUM_POSN    4

// Position in buffer of HERMES2 Frame, Comm & Ctrl and IQ data
#define CCD_FRAME1_POSN        8
#define CCD_FRAME1_C_C_POSN    11
#define CCD_FRAME1_DATA_POSN   16
#define CCD_FRAME2_POSN        520
#define CCD_FRAME2_C_C_POSN    523
#define CCD_FRAME2_DATA_POSN   528
#define CCD_USB_FRAME_SIZE     512
#define CCD_BUFFER_IQ_PAIRS    63

typedef struct _CMND_CTRL_AUDIO_IQ_DATA
{
  // PC to Metis C&C & Data buffer
  uint8_t buffer[CCD_BUFFER_SIZE];

  // Command | Control data bytes
  uint8_t
    Cn1[CCD_NUM_ADRESSES][CCD_NUM_CC_BYTES],
    Cn1_address[CCD_ADDR_STACK],
    Cn2[CCD_NUM_ADRESSES][CCD_NUM_CC_BYTES],
    Cn2_address[CCD_ADDR_STACK],
    addr_stack_idx;

  // C & C & Data packet sequence number
  uint32_t sequence_num;

} Cmnd_Ctrl_Audio_IQ_Data_t;

//----------------------------------------------------------------------

/* pc_to_hw.c */
void Init_Cmnd_Ctrl_Audio_IQ_Data(void);
BOOLEAN Device_Start_Stop(uint8_t command);
BOOLEAN DDC_Start(Transceiver_t *TRx, uint8_t command);
BOOLEAN Pack_DUC_Tx_Data(const int16_t *data_i, const int16_t *data_q, const int16_t *left, const int16_t *right);
BOOLEAN Send_Cmnd_Ctrl_Audio_IQ_Data(char *cmnt);

//----------------------------------------------------------------------

#endif

