/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HW_TO_PC_H
#define HW_TO_PC_H  1

#include "../common/transceiver.h"
#include <gtk/gtk.h>

//----------------------------------------------------------------------

// Microphone number of samples in Metis packet and sample rate S/s
#define MIC_NUM_OF_SAMPLES  126
#define MIC_SAMPLE_RATE     48000

// Max value of (16-bit) Mic data, for Mic compressor
#define MIC_MAX_VALUE    32000

//----------------------------------------------------------------------

// HL2 definitions of various constants and flags
#define PA_POWER_CALIBRATE    76000.0
#define PSU_VOLTS_CALIBRATE   119.0
#define PLL_LOCK_STATUS       0x10
#define PTT_REPORT            BIT_0
#define DASH_REPORT           BIT_1
#define DOT_REPORT            BIT_2

// Maximum PA output power in Watts
#define MAX_PA_POWER    5.0

//----------------------------------------------------------------------

// Command and Control locations in buffer
#define CC_C0    0
#define CC_C1    1
#define CC_C2    2
#define CC_C3    3
#define CC_C4    4

// Nominal value of 3.3v supply, ideally should be measured
#define REF_3_3_VOLT   3.30

// Scale factor equal to number of steps in monitor ADC
#define ADC_SCALE   4096.0

// Factor used to calculate fwd and rev power
#define V2PWR_FACTOR    0.9034

//----------------------------------------------------------------------

// hw_to_pc.c
gboolean Display_PA_Power(gpointer data);
void *Data_Receive_Thread(void *arg);

//----------------------------------------------------------------------

#endif

