/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef DISCOVERY_H
#define DISCOVERY_H   1

#include "../common/common.h"
#include <arpa/inet.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <stdint.h>

//----------------------------------------------------------------------

// Start of Metis packets (first two bytes)
#define METIS_PACKET_LEADER      0xEFFE

// Discovery Response data
typedef struct _DISCOVERED
{
  // Discover Reply data
  uint8_t
    device_status,    // Byte #2
    mac_address[6],   // Byte #3-8
    gateware_ver[2],  // Byte #9-#15
    device_type,      // Byte #10
    num_of_ddcs,      // Byte #19
    num_of_adcs,      // Derived from device type
    wideband_data,    // Byte #20 Bits 7:6
    board_build_id,   // Byte #20 Bits 5:0
    external_cw_key,  // Byte #27 Bit 7
    ptt_tx_on_status, // Byte #27 Bit 6
    adc_clip_count,   // Byte #27 Bits 1:0
    UO_flow_recovery, // Byte #36 bit 7
    tx_iq_fifo_count; // Byte #36 bit 6:0

  double
    temperature,      // Byte 28
    fwd_power,        // Byte 30
    rev_power,        // Byte 32
    pa_current;       // Byte 34

  char device_name[16];
  char interface_name[32];

  struct sockaddr_in network_address;
  socklen_t network_address_length;

  struct sockaddr_in interface_address;
  socklen_t interface_address_length;

  BOOLEAN
    transmit_on,         // Whether transmitter is ON
    pa_power_up,         // Increase PA Power O/P
    lna_gain_auto,       // Status On|Off of ADC LNA Gain Auto Managed
    lna_gain_hw,         // Status On|Off of ADC LNA Gain Hardware Managed
    tx_pa_enable,        // Status On|Off of TX PA enable
    duplex,              // Enable Rx/Tx operation in Duplex mode
    rcve_thread_run,     // Run Data Receive Thread
    rcve_thread_running; // Data Receive Thread exited

  // *** Data below are used to save Discovered device state ***
  uint8_t
    filter_settings,  // Rx And Tx filter selection and Rx antenna selection
    dot_dash_ptt,     // Status of Dot, Dash and PTT Report in High Priority Packet
    tx_pa_tune;       // Signal to Tune Power Amplifier

  int8_t lna_gain;    // Value of ADC LNA Gain setting

  uint32_t
    frequency_min,  // Minimum DDC frequency in Hz
    frequency_max;  // Maximum DDC frequency in Hz

  // Data Receive Thread thread id
  pthread_t data_receive_thread;

} discovered_device_t;

//----------------------------------------------------------------------

// discovery.c
gboolean Do_Discovery( gpointer data );

//----------------------------------------------------------------------

#endif

