/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HELL_SHARE_H
#define HELL_SHARE_H   1

#include "../common/common.h"
#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdint.h>

/* Normal height and short height
 * for the Receive drawingarea */
#define NORMAL_HEIGHT   420
#define SHORT_HEIGHT    210

// Glyph data structure
typedef struct _GLYPH_DATA
{
  uint8_t
    encoding,
    dwidth_x,
    dwidth_y;

  int8_t
    bbx_w,
    bbx_h,
    bbx_x,
    bbx_y;

  uint32_t *bitmap;

} glyph_data_t;

//-------------------------------------------------------------------

// Font data structure
typedef struct _FONT_DATA
{
  // Name of current font
  char font_name[READ_LINE_BUF_SIZE];

  // Font bounding box
  int8_t fbb_w, fbb_h, fbb_x, fbb_y;

  uint16_t
    first_glyph, // First character in font file
    last_glyph,  // Last character in font file
    num_glyphs;  // Number of chars in font file

  glyph_data_t *glyph_data;

} font_data_t;

//-------------------------------------------------------------------

// Configuration parameters structure
typedef struct _HELL_RC_DATA
{
  gchar font_file[FILE_NAME_SIZE]; // Font file name

  // Hell Schreiber transmit baud rate
  double baud_rate;

  uint8_t
    contrast,           // Receive text contrast request
    word_wrap,          // Word wrap column number
    dot_size,           // Receive dot height in pixels
    num_rows;           // Number of character rows in Rx window

  uint16_t
    center_line,        // Position of tuning reference in ifft window
    bitmap_height,      // Receive bitmap height in pixels
    bitmap_width,       // Receive bitmap width in pixels
    rxarea_width,       // Rx drawingarea width
    rxarea_height;      // Rx drawingarea height

  uint32_t
    tx_buff_len,        // Tx signal samples buffer size
    rx_buff_len,        // Rx signal samples buffer size
    tx_samp_per_cycle,  // DUC samples per cycle of BFO freq.
    rx_samp_per_cycle,  // RX Audio samples per cycle of BFO freq.
    tx_samp_per_dot,    // DUC samples per Hell character half element
    rx_samp_per_dot;    // ADC samples per Hell character half element

  // CW message to send
  char cw_mesg[25];

  // Font data buffer
  font_data_t font_data;

  char
    hell_glade[FILE_NAME_SIZE],  // Glade file path
    rc_fpath[FILE_NAME_SIZE];    // File path to hellrc

  // Deskew Hell Rx text lines
  int16_t deskew;

} hell_rc_data_t;

//-------------------------------------------------------------------

// Global widgets
typedef struct _HELL_GUI
{
  GtkWidget
    *window,
    *drawingarea,
    *popup_menu,
    *xmit_status,
    *rcve_status,
    *hell_scope;

  // GTK Builder objects
  GtkBuilder *window_builder;
  GtkBuilder *popup_menu_builder;

  // Text buffers for text viewers
  GtkTextBuffer *tx_text_buffer;
  GtkTextView   *tx_text_view;
  GtkTextIter    tx_text_buffer_iter;

  uint16_t hell_scope_width, hell_scope_height;

} hell_gui_t;

//-------------------------------------------------------------------

// Global widgets
extern hell_gui_t hell_gui;

// Runtime config data
extern hell_rc_data_t hell_rc_data;

// Waterfall data struct
extern pixbuffer_t hell_wfall;

// Hell IFFT() data structure
extern ifft_data_t hell_ifft_data;

// Macros attached to F1-F9
extern char *hell_macro[NUM_OF_LABELS];

// Receive window and waterfall pixbuffs
extern pixbuffer_t hell_receive_pixbuf;

// Hell waterfall pixbuffer struct
extern pixbuffer_t hell_wfall;

// Buffer for Tx to Rx Loopback
extern uint8_t *loopback_buf;

#endif

