/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HELL_DETECT_H
#define HELL_DETECT_H   1

#include "../common/common.h"
#include <stdint.h>
#include <cairo/cairo.h>

// Receiver BFO Frequency
#define HELL_AUDIO_FREQUENCY    600

// detect.c
uint8_t Get_Element(uint8_t *elem_lev);
uint8_t Feld_Level(uint8_t *elem_lev);
uint8_t FMHell_Level(uint8_t *elem_lev);
void Hell_Display_Signal(cairo_t *cr);
void Hell_Free_Points(void);

#endif

