/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HELL_CALLBACKS_H
#define HELL_CALLBACKS_H   1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

// callbacks.c
void on_hell_window_destroy(GObject *object, gpointer user_data);
gboolean on_hell_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_hell_quit_activate(GtkMenuItem *menuitem, gpointer user_data);
gboolean on_hell_tx_textview_key_press(GtkWidget *widget, const GdkEventKey *event, gpointer user_data);
gboolean on_hell_tx_textview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_hell_transmit_clicked(GtkButton *button, gpointer user_data);
void on_hell_receive_clicked(GtkButton *button, gpointer user_data);
void on_hell_rx_drawingarea_configure(GtkWidget *widget, GdkEventConfigure *event, gpointer user_data);
gboolean on_hell_rx_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_hell_rx_drawingarea_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_hell_deskew_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_hell_height_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_hell_contrast_value_changed(GtkRange *range, gpointer user_data);
gboolean on_hell_wfall_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_hell_scope_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_hell_scope_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_hell_callsign_changed(GtkEditable *editable, gpointer user_data);
void on_hell_rst_out_changed(GtkEditable *editable, gpointer user_data);
void on_hell_rst_in_changed(GtkEditable *editable, gpointer user_data);
void on_hell_op_name_changed(GtkEditable *editable, gpointer user_data);
void on_hell_qth_name_changed(GtkEditable *editable, gpointer user_data);
void on_hell_locator_changed(GtkEditable *editable, gpointer user_data);
void on_hell_band_changed(GtkEditable *editable, gpointer user_data);
void on_hell_new_record_clicked(GtkButton *button, gpointer user_data);
void on_hell_save_record_clicked(GtkButton *button, gpointer user_data);
void on_hell_clear_fields_clicked(GtkButton *button, gpointer user_data);
void on_hell_clear_windows_clicked(GtkButton *button, gpointer user_data);
void on_hell_macro_clicked(GtkButton *button, gpointer user_data);
void on_hell_feldhell_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_fmhell_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_bdrate_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_font_selector_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_filechooser_response(GtkDialog *dialog, gint response_id, gpointer user_data);
void on_hell_filechooser_destroy(GObject *object, gpointer user_data);
void on_hell_show_font_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_reverse_video_toggled(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_loopback_toggled(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_md2x2_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_md3x3_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_md4x4_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_capitalize_letters_toggled(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_record_qsos_toggled(GtkMenuItem *menuitem, gpointer user_data);
void on_hell_identify_in_cw_activate(GtkMenuItem *menuitem, gpointer user_data);

#endif

