/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "xplanet.h"
#include "shared.h"
#include "../common/common.h"
#include "../common/guest_utils.h"
#include "../common/utils.h"

//------------------------------------------------------------------

// Xplanet configuration files
static FILE
  *config_fd   = NULL,
  *marker_fd   = NULL,
  *greatarc_fd = NULL;

// Opens the xplanet config files
  BOOLEAN
FTx_Open_Xplanet_Files( void )
{
  if( (Open_File(&config_fd,   ftx_rc.xplanet_config_file, "w") == FAILURE) ||
      (Open_File(&marker_fd,   ftx_rc.xplanet_marker_file, "w") == FAILURE) ||
      (Open_File(&greatarc_fd, ftx_rc.xplanet_arc_file,    "w") == FAILURE) )
  {
    FTx_Close_Xplanet_Files();
    return( False );
  }

  /* Setup xplanet config file */
  fprintf( config_fd, "arc_file=%s\nmarker_file=%s\n",
      ftx_rc.xplanet_arc_file, ftx_rc.xplanet_marker_file );

  /* Enter "Home" station's position in marker file */
  fprintf( marker_fd, "%8.3f %8.3f \"%s\" %s\n",
      ftx_rc.home_latitude, ftx_rc.home_longitude, ftx_rc.home_name, "color=red" );

  return( True );
} // FTx_Open_Xplanet_Files()

//------------------------------------------------------------------

// Closes xplanet config files, if open
  void
FTx_Close_Xplanet_Files( void )
{
  if( config_fd   != NULL ) Close_File( &config_fd );
  if( greatarc_fd != NULL ) Close_File( &greatarc_fd );
  if( marker_fd   != NULL ) Close_File( &marker_fd );
} // FTx_Close_Xplanet_Files()

//------------------------------------------------------------------

/* FTx_Prepare_Xplanet
 *
 * Displays Home and Remote locations
 * and Great Circle arc using xplanet
 */
  void
FTx_Prepare_Xplanet( const char *locator, const char *dx_call )
{
  // Calculate "Remote" station's position
  Gridloc_to_Position( locator, &ftx_rc.dx_latitude, &ftx_rc.dx_longitude );

  /* Enter "Remote" position in marker file */
  fprintf( marker_fd, "%8.3f %8.3f \"%s\" %s\n",
      ftx_rc.dx_latitude, ftx_rc.dx_longitude, dx_call, "color=yellow" );

  /* Enter Home/Remote positions in greatarc file */
  fprintf( greatarc_fd, "%8.3f %8.3f %8.3f %8.3f %s\n",
      ftx_rc.home_latitude, ftx_rc.home_longitude,
      ftx_rc.dx_latitude,   ftx_rc.dx_longitude,
      "color=yellow" );

  return;
} /* End of FTx_Prepare_Xplanet() */

/*------------------------------------------------------------------------*/

