/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef  SHARED_H
#define  SHARED_H   1
#include "constants.h"
#include "../common/common.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>

// Sizes of strings
#define FTX_CALL_SIZE        13
#define FTX_LOC_SIZE         7
#define FTX_SNR_SIZE         4
#define FTX_FINAL_SIZE       7
#define FTX_MESSAGE_SIZE     23
#define FTX_CALL_STR_SIZE    16
#define FTX_HOME_NAME_SIZE   24
#define FTX_DATE_SIZE        9
#define FTX_TIME_SIZE        5
#define FTX_FREQ_SIZE        10
#define FTX_MODE_SIZE        4
#define FTX_TXT_SIZE         48

#define FTX_RX_SAMPLE_RATE      12000  // Sample rate of FTx Rx decoder
#define FTX_TX_SAMPLE_RATE      48000  // Sample rate of FTx Tx encoder


//-----------------------------------------------------------------------

typedef struct _FTX_RC
{
  char
    ftx_dir[FILE_NAME_SIZE],    // FTX working directory
    ftx_glade[FILE_NAME_SIZE],  // Glade file path
    rc_fpath[FILE_NAME_SIZE];   // File path to hellrc

  // Xplanet config files
  char
    xplanet_command[XPLANET_CMND_SIZE],
    xplanet_options[FILE_NAME_SIZE],
    xplanet_config_file[FILE_NAME_SIZE],
    xplanet_marker_file[FILE_NAME_SIZE],
    xplanet_arc_file[FILE_NAME_SIZE];

  char
    own_call[FTX_CALL_SIZE],        // Station callsign
    own_locator[FTX_LOC_SIZE],      // Station QTH locator
    home_name[FTX_HOME_NAME_SIZE];  // Station QTH home name

  // String to be highlighted in decoded FTx message
  char highlight[FTX_CALL_SIZE];

  // Latitude and Longitude of home position
  double home_latitude, home_longitude;

  // Latitude and Longitude of home position
  double dx_latitude, dx_longitude;

  // Transmitt (audio) frequency
  uint16_t tx_frequency;

  uint8_t
    reply_cq_idx,    // Combobox index of auto CQ preference
    select_cq_idx;   // Combobox index of create CQ preference

  // Index of Active Message, e.g. message entry in use
  int8_t active_mesg_idx;

  ftx_protocol_t proto;

  BOOLEAN
    band_xplanet,         // Enable xplanet display of Band monitor
    dx_xplanet,           // Enable xplanet display of DX station
    auto_clear,           // Enable auto clearing of Messages displays
    auto_qso,             // Enable automatically conducting QSO's
    auto_sequence,        // Enable auto sequencing of QSO messages
    auto_save,            // Enable auto saving of QSO records
    colorize,             // Enable colorization of fields (CQ, own call etc)
    tx_enabled,           // FTx Transmit is enabled
    tx_even,              // Enable transmission on even periods (or odd if not)
    slot_for_tx,          // Current time slot is for the transmitter
    highlighted,          // Show only Messages with highlighted text
    with_cq,              // Show only Messages that are CQ calls
    calling_me,           // Show only Messages that are calls to me
    dx_call_show,         // Show only Messages that contain the DX callsign
    send_cq_ready,        // A CQ string has been created
    messages_ready,       // Standard messages ready
    decoder_exit,         // Exit the FTx decoder thread
    decoder_thrd_running; // Actual Decoder thread is running

} ftx_rc_t;

// Runtime config data
extern ftx_rc_t ftx_rc;

//-----------------------------------------------------------------------

#define NUM_SEND_LABELS    6
extern const char *label_numb[];

enum _MESG_ENTRIES
{
  FTX_NO_ACTIVE_MESG = -1,
  FTX_REPLY_CQ_ENTRY,
  FTX_SNR_ENTRY,
  FTX_R_SNR_ENTRY,
  FTX_RRR_ENTRY,
  FTX_RR73_ENTRY,
  FTX_73_ENTRY,
  FTX_CQ_ENTRY,
  NUM_MESG_ENTRIES
};

#define NO_ACTIVE_MESG  (ftx_rc.active_mesg_idx == FTX_NO_ACTIVE_MESG)
#define ACTIVE_MESSAGE  (ftx_rc.active_mesg_idx >= 0)
#define CQ_MESSAGE      (ftx_rc.active_mesg_idx == FTX_CQ_ENTRY)

// Wspr GUI data
typedef struct _FTX_GUI
{
  // Main Window widgets
  GtkWidget
    *window,         // FTX's main window
    *band_scroller;  // Bands activity scrolled window

  // Check buttons that enable various functions in hermes2
  GtkWidget
    *inqso_xplanet,   // Enable Xplanet display of in-QSO station
    *band_xplanet,    // Enable Xplanet display of stations in Bands monitor
    *colorize,        // Enable colorization of fields (CQ, own call etc)
    *auto_clear,      // Enable auto clearing of treeview before new display
    *with_cq,         // Enable display of Messages that are CQ calls
    *calling_me,      // Enable display of Messages with own callsign
    *dx_call,         // Enable display of Messages with DX callsign
    *highlighted,     // Enable colorization of fields with pattern set by user
    *auto_sequence,   // Enable auto sequencing of QSO messages to aid operator
    *auto_qso,        // Enable automatic conduct of QSO. Only if I succeed in this ;-)
    *tx_even,         // Enable Transmission on even periods (otherwise odd)
    *auto_save;       // Enable Auto Save of QSO Record

  /* These are the labels that display info in the
   * Selected Message and DX Station Details display */
  GtkWidget
    *decoded_label,    // Number of Messages decoded
    *magn_label,       // Average Magnitude of signals
    *hashtable_label,  // Number of entries in Hash Table
    *monitor_label,    // Label used in "Monitor" button
    *time_label,       // Time of Message in Messages display
    *snr_label,        // SNR of DX station in Messages display
    *dt_label,         // Dt of DX transmission in Messages display
    *freq_label,       // Frequency of DX station in Messages display
    *field1_label,     // Field1 in Messages display
    *field2_label,     // Field2 in Messages display
    *field3_label,     // Field3 in Messages display
    *dx_call_entry,    // Callsign of DX station in QSO Details display
    *dx_snr_entry,     // DX station SNR in QSO Details display
    *own_snr_entry,    // Own SNR Report in QSO Details display
    *dx_freq_entry,    // DX station Frequency in QSO Details display
    *dx_grid_entry,    // DX station Grid in QSO Details display
    *dx_azim_entry,    // DX station Azimuth in QSO Details display
    *dx_dist_entry,    // DX station Distance in QSO Details display
    *dx_final_entry,   // DX station Final in QSO Details display
    *halt_tx_label,    // Label for the "HALT TX" button in Tx Control
    *send_cq_label,    // Label for the "Send CQ" button in Tx Control
    *ftx_log_label;    // Label to display error and status messages

  // Labels for the Send Buttons in Standard Messages
  GtkWidget *send_label[NUM_SEND_LABELS];

  // Entries used for creating Standard Messages. Last is for CQ's.
  GtkWidget *message_entry[NUM_MESG_ENTRIES];

  // Combo Boxes to select CQ for Auto Sequence reply and CQ Generator
  GtkWidget
    *reply_cq_combo,
    *select_cq_combo;

  // Transmit Frequency spin button
  GtkWidget *tx_frequency;

  // Treeviews to display Band Activity and Receive Messages
  GtkListStore *mesg_store;
  GtkTreeView  *ftx_mesg_treeview;

  // Gtk builders for some above that need to be global
  GtkBuilder *window_builder;
  GtkBuilder *popup_menu_builder;

} ftx_gui_t;

extern ftx_gui_t ftx_gui;

//-----------------------------------------------------------------------

// QSO Record structure (call, rprt, loc, date-time, freq etc)
typedef struct _FTX_QSO_RECORD
{
  char
    dx_call[FTX_CALL_SIZE],    // DX station callsign
    dx_loc[FTX_LOC_SIZE],      // DX station grid locator
    dx_final[FTX_FINAL_SIZE],  // DX station's final (RRR or RR73 or 73 etc)
    dx_snr[FTX_SNR_SIZE],      // DX station  outgoing SNR
    own_snr[FTX_SNR_SIZE],     // Own station incoming SNR
    frequency[FTX_FREQ_SIZE],  // Frequency of QSO in Hz
    mode[FTX_MODE_SIZE],       // FTX Mode (FT4 or FT8)
    date[FTX_DATE_SIZE],       // Date of QSO in ADIF format
    time[FTX_TIME_SIZE];       // Time of QSO in ADIF format

  // QSO and Message status flags
  BOOLEAN
    cq_call_received,
    dx_call_received,
    own_call_received,
    own_snr_received,
    dx_loc_received,
    dx_final_received;

  FILE *adif_log_fp, *station_log_fp;

} ftx_qso_record_t;

extern ftx_qso_record_t ftx_qso_record;

//-----------------------------------------------------------------------

// FTx signal: The FTx tones as samples for the Tx DUC
typedef struct _FTX_SIGNAL
{
  uint32_t num_samples;
  double   *signal;
} ftx_signal_t;

extern ftx_signal_t ftx_signal;

//-----------------------------------------------------------------------

// Decoded messages buffer (time, snr, dT, freq and message) and its index
extern char **mesg_data;

//-----------------------------------------------------------------------

#endif

