/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "sequence.h"
#include "../hpsdr/pc_to_hw.h"
#include "../Hermes2/callback_func.h"
#include "../Hermes2/modulate.h"
#include "shared.h"
#include <stdio.h>

//-----------------------------------------------------------------------

/* Modulate_FTx()
 *
 * Transmits the samples produced by the FTx encoder by using
 * the SSB (USB) Modulator to supply the DUC with the FTx tones
 */
  void
Modulate_FTx( void *arg )
{
  static uint32_t samples_cnt = 0;

  // Transmit the samples buffer
  Modulate_SSB( (void *)(ftx_signal.signal + samples_cnt) );

  // Count up samples transmitted
  samples_cnt += DUC_NUM_IQ_SAMPLES;

  // All samples sent to TX 
  if( samples_cnt >= ftx_signal.num_samples )
  {
    // Disable Modulator and free samples buffer
    MOX_Control( MOX_OFF );
    Modulator = NULL;
    Mem_Free( (void **)ftx_signal.signal );

    // Markup selected message in green at end of transmission
    if( CQ_MESSAGE )
      Set_Label_Markup( GTK_LABEL(ftx_gui.send_cq_label), MARKUP_GREEN, " Send CQ " );
    else if( ACTIVE_MESSAGE )
      Set_Label_Markup( GTK_LABEL(ftx_gui.send_label[ftx_rc.active_mesg_idx]),
          MARKUP_GREEN, label_numb[ftx_rc.active_mesg_idx] );

    // Reset active message index and samples count
    ftx_rc.active_mesg_idx = FTX_NO_ACTIVE_MESG;
    samples_cnt = 0;

  } // if( samples_cnt >= ftx_signal.num_samples )

} // Modulate_FTx()

//-----------------------------------------------------------------------

