/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef _INCLUDE_LDPC_H_
#define _INCLUDE_LDPC_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C"
{
#endif

  // codeword is 174 log-likelihoods.
  // plain is a return value, 174 ints, to be 0 or 1.
  // iters is how hard to try.
  // ok == 87 means success.
  void ldpc_decode(const double codeword[], int max_iters, uint8_t plain[], int *ok);

  void bp_decode(const double codeword[], int max_iters, uint8_t plain[], int *ok);

#ifdef __cplusplus
}
#endif

#endif // _INCLUDE_LDPC_H_

