/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "interface.h"
#include "callback_func.h"
#include "display.h"
#include "shared.h"
#include "utils.h"
#include "../common/common.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include <gtk/gtk.h>
#include <stdlib.h>

//------------------------------------------------------------------

#define FTX_WINDOW_IDS \
  "ftx_window", \
  "tx_freq_adjustment", \
  NULL

//------------------------------------------------------------------

static gchar ftx_glade[FILE_NAME_SIZE];

/* Create_Ftx_Window()
 *
 * Creates the main FTX window
 */
  GtkWidget *
Create_Ftx_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { FTX_WINDOW_IDS };

  // Setup file path to FTX working directory
  Strlcpy( ftx_rc.ftx_dir, getenv("HOME"),   sizeof(ftx_rc.ftx_dir) );
  Strlcat( ftx_rc.ftx_dir, "/.hermes2/ftx/", sizeof(ftx_rc.ftx_dir) );
  Strlcpy( ftx_glade, ftx_rc.ftx_dir, sizeof(ftx_glade) ) ;
  Strlcat( ftx_glade, "ftx.glade",    sizeof(ftx_glade) ) ;

  // Create FTx main window
  Gtk_Builder( builder, ftx_glade, object_ids );
  ftx_gui.window = Builder_Get_Object( *builder, "ftx_window" );
  hermes2_gui.guest_window = ftx_gui.window;

  // Create and show main window
  gtk_widget_show( ftx_gui.window );

  // Create treeview objects
  ftx_gui.ftx_mesg_treeview =
    GTK_TREE_VIEW( Builder_Get_Object( *builder, "ftx_mesg_treeview") );

  // Create the list store
  FTx_List_Store( &ftx_gui.mesg_store, ftx_gui.ftx_mesg_treeview );

  // Create the Decoder Status labels
  ftx_gui.decoded_label   = GTK_WIDGET( Builder_Get_Object( *builder, "decoded_label") );
  ftx_gui.magn_label      = GTK_WIDGET( Builder_Get_Object( *builder, "magn_label") );
  ftx_gui.hashtable_label = GTK_WIDGET( Builder_Get_Object( *builder, "hashtable_label") );
  ftx_gui.time_label      = GTK_WIDGET( Builder_Get_Object( *builder, "time_label") );
  ftx_gui.snr_label       = GTK_WIDGET( Builder_Get_Object( *builder, "snr_label") );
  ftx_gui.dt_label        = GTK_WIDGET( Builder_Get_Object( *builder, "dt_label") );
  ftx_gui.freq_label      = GTK_WIDGET( Builder_Get_Object( *builder, "freq_label") );
  ftx_gui.field1_label    = GTK_WIDGET( Builder_Get_Object( *builder, "field1_label") );
  ftx_gui.field2_label    = GTK_WIDGET( Builder_Get_Object( *builder, "field2_label") );
  ftx_gui.field3_label    = GTK_WIDGET( Builder_Get_Object( *builder, "field3_label") );
  ftx_gui.dx_call_entry   = GTK_WIDGET( Builder_Get_Object( *builder, "dx_call_entry") );
  ftx_gui.dx_snr_entry    = GTK_WIDGET( Builder_Get_Object( *builder, "dx_snr_entry") );
  ftx_gui.own_snr_entry   = GTK_WIDGET( Builder_Get_Object( *builder, "own_snr_entry") );
  ftx_gui.dx_freq_entry   = GTK_WIDGET( Builder_Get_Object( *builder, "dx_freq_entry") );
  ftx_gui.dx_grid_entry   = GTK_WIDGET( Builder_Get_Object( *builder, "dx_grid_entry") );
  ftx_gui.dx_azim_entry   = GTK_WIDGET( Builder_Get_Object( *builder, "dx_azim_entry") );
  ftx_gui.dx_dist_entry   = GTK_WIDGET( Builder_Get_Object( *builder, "dx_dist_entry") );
  ftx_gui.dx_final_entry  = GTK_WIDGET( Builder_Get_Object( *builder, "dx_final_entry") );
  ftx_gui.halt_tx_label   = GTK_WIDGET( Builder_Get_Object( *builder, "halt_tx_label") );
  ftx_gui.send_cq_label   = GTK_WIDGET( Builder_Get_Object( *builder, "send_cq_label") );
  ftx_gui.monitor_label   = GTK_WIDGET( Builder_Get_Object( *builder, "monitor_label") );
  ftx_gui.ftx_log_label   = GTK_WIDGET( Builder_Get_Object( *builder, "ftx_log_label") );

  // Create the Send Message button labels
  for( uint8_t idx = 0; idx < NUM_SEND_LABELS; idx++ )
  {
#define LBL_SIZE  12
    gchar lbl[LBL_SIZE];
    snprintf( lbl, LBL_SIZE, "send%d_label", idx + 1 );
    ftx_gui.send_label[idx] = GTK_WIDGET( Builder_Get_Object( *builder, lbl) );
    Set_Label_Markup( GTK_LABEL(ftx_gui.send_label[idx]), MARKUP_GREY, label_numb[idx] );
  }

  // Set the "inactive" markup on Send CQ label
  Set_Label_Markup( GTK_LABEL(ftx_gui.send_cq_label), MARKUP_GREY, " Send CQ " );

  // Set "inactive" label to Monitor toggle button
  Set_Label_Markup( GTK_LABEL(ftx_gui.monitor_label), MARKUP_GREY, " MONITOR " );

  // Set markup text in status/log label
  Set_Label_Markup( GTK_LABEL(ftx_gui.ftx_log_label), MARKUP_GREY, " Log/Status Messages " );

  // Set "inactive" label to Tx Enable toggle button
  Set_Label_Markup( GTK_LABEL(ftx_gui.halt_tx_label), MARKUP_GREY, " ENABLE TX " );

  // Create Check Button widgets
  ftx_gui.inqso_xplanet = GTK_WIDGET( Builder_Get_Object( *builder, "inqso_xplanet") );
  ftx_gui.band_xplanet  = GTK_WIDGET( Builder_Get_Object( *builder, "band_xplanet") );
  ftx_gui.colorize      = GTK_WIDGET( Builder_Get_Object( *builder, "colorize") );
  ftx_gui.auto_clear    = GTK_WIDGET( Builder_Get_Object( *builder, "auto_clear") );
  ftx_gui.with_cq       = GTK_WIDGET( Builder_Get_Object( *builder, "with_cq") );
  ftx_gui.calling_me    = GTK_WIDGET( Builder_Get_Object( *builder, "calling_me") );
  ftx_gui.dx_call       = GTK_WIDGET( Builder_Get_Object( *builder, "dx_call") );
  ftx_gui.highlighted   = GTK_WIDGET( Builder_Get_Object( *builder, "highlighted") );
  ftx_gui.auto_sequence = GTK_WIDGET( Builder_Get_Object( *builder, "auto_sequence") );
  ftx_gui.auto_qso      = GTK_WIDGET( Builder_Get_Object( *builder, "auto_qso") );
  ftx_gui.tx_even       = GTK_WIDGET( Builder_Get_Object( *builder, "tx_even") );
  ftx_gui.auto_save     = GTK_WIDGET( Builder_Get_Object( *builder, "auto_save") );

  // Create Combo boxes
  ftx_gui.reply_cq_combo  = GTK_WIDGET( Builder_Get_Object( *builder, "reply_cq_combo") );
  ftx_gui.select_cq_combo = GTK_WIDGET( Builder_Get_Object( *builder, "select_cq_combo") );

  // Create the Tx Frequency Spinbutton
  ftx_gui.tx_frequency = GTK_WIDGET( Builder_Get_Object( *builder, "tx_frequency") );

  // Create the Message Entries
#define MSG_SIZE  15
  for( uint8_t idx = 0; idx < NUM_MESG_ENTRIES; idx++ )
  {
    gchar msg[MSG_SIZE];
    snprintf( msg, MSG_SIZE, "message_entry%d", idx + 1 );
    ftx_gui.message_entry[idx] = GTK_WIDGET( Builder_Get_Object( *builder, msg) );
  }

  // Initialize some QSO Record objects
  ftx_qso_record.cq_call_received  = False;
  ftx_qso_record.dx_call_received  = False;
  ftx_qso_record.own_call_received = False;
  ftx_qso_record.own_snr_received  = False;
  ftx_qso_record.dx_loc_received   = False;
  ftx_qso_record.dx_final_received = False;

  // Initialize some RC objects
  ftx_rc.active_mesg_idx = FTX_NO_ACTIVE_MESG;
  ftx_rc.highlight[0]    = '\0';
  ftx_rc.send_cq_ready   = False;
  ftx_rc.messages_ready  = False;
  ftx_rc.tx_enabled      =  False;
  ftx_rc.decoder_exit    = False;
  ftx_rc.decoder_thrd_running = False;

  Flag[FTX_DEC_DISPLAY_CB] = False;

  // Load runtime config file, abort on error
  g_idle_add( FTx_Read_Config, NULL );

  return( ftx_gui.window );
} // Create_Ftx_Window()

//------------------------------------------------------------------

