/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef DISPLAY_H
#define DISPLAY_H   1

#include "decode_ftx.h"
#include "shared.h"
#include <gtk/gtk.h>

// Messages tree columns
enum
{
  FTX_TREEVIEW_TIME = 0,
  FTX_TREEVIEW_SNR,
  FTX_TREEVIEW_DT,
  FTX_TREEVIEW_FREQ,
  FTX_TREEVIEW_COL1,
  FTX_TREEVIEW_COL2,
  FTX_TREEVIEW_COL3,
  FTX_TREEVIEW_COLS
};

#define FTX_TREEVIEW_ROWS   64

//----------------------------------------------------------------------

void FTx_List_Store(GtkListStore **list_store, GtkTreeView *tree_view);
void Display_FTx_Data(char **mesg_data, int16_t data_idx, GtkListStore *list_store);
void Decoder_Status(int num_decoded, int hashtable_size, double max_magn);

#endif

