/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "callbacks.h"
#include "callback_func.h"
#include "constants.h"
#include "decode_ftx.h"
#include "encode_ftx.h"
#include "display.h"
#include "interface.h"
#include "shared.h"
#include "utils.h"
#include "../common/guest_utils.h"
#include "../common/shared.h"
#include <ctype.h>
#include <gtk/gtk.h>

//------------------------------------------------------------------

  void
FTx_g_Idle_cb( gpointer data )
{
  Flag[FTX_DEC_DISPLAY_CB] = False;
}

//------------------------------------------------------------------

  void
on_ftx_window_destroy(
    GObject  *object,
    gpointer  user_data )
{
  FTx_Cleanup();
}

//------------------------------------------------------------------

  gboolean
on_ftx_window_delete(
    GtkWidget *widget,
    GdkEvent  *event,
    gpointer   user_data )
{
  // Stop FTx Decoder and save config
  ftx_rc.decoder_exit = True;
  FTx_Save_Config();

  // Do not quit FTx if Display idle callback is running
  if( !Flag[FTX_DEC_DISPLAY_CB] )
    Guest_Quit_Activate( ftx_gui.window );

  return( TRUE );
}

//------------------------------------------------------------------

  void
on_ftx_quit_clicked(
    GtkButton *button,
    gpointer     user_data)
{
  // Stop FTx Decoder and save config
  ftx_rc.decoder_exit = True;
  FTx_Save_Config();

  // Do not quit FTx if Display idle callback is running
  if( !Flag[FTX_DEC_DISPLAY_CB] )
    Guest_Quit_Activate( ftx_gui.window );
}

//------------------------------------------------------------------

  void
on_mesgs_clear_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  // Clears Messages display
  FTx_Clear_Messages();
}

//------------------------------------------------------------------

  void
on_ftx_auto_clear_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.auto_clear = True;
  else
    ftx_rc.auto_clear = False;
}

//------------------------------------------------------------------

  void
on_receive_clear_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  // Clears labels with FTx QSO details
  FTx_Clear_Received();

  // Clears Standard Messages with DX call cleared
  FTx_Std_Messages();
}

//------------------------------------------------------------------

  void
on_ftx_monitor_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  FTx_Monitor_Toggled( togglebutton );
}

//------------------------------------------------------------------

  void
on_ftx_highlighted_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.highlighted = True;
  else
    ftx_rc.highlighted = False;
}

//------------------------------------------------------------------

  void
on_ftx_highlight_activate(
    GtkEntry *entry,
    gpointer user_data )
{
  Strlcpy( ftx_rc.highlight, gtk_entry_get_text(entry), sizeof(ftx_rc.highlight) );
  for( uint8_t idx = 0; ftx_rc.highlight[idx] != '\0'; idx++ )
    ftx_rc.highlight[idx] = (char)( toupper(ftx_rc.highlight[idx]) );
  gtk_entry_set_text( entry, (gchar *)ftx_rc.highlight );
}

//------------------------------------------------------------------

  void
on_ftx_with_cq_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.with_cq = True;
  else
    ftx_rc.with_cq = False;
}

//------------------------------------------------------------------

  void
on_ftx_calling_me_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.calling_me = True;
  else
    ftx_rc.calling_me = False;
}

//------------------------------------------------------------------

  void
on_ftx_dx_call_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.dx_call_show = True;
  else
    ftx_rc.dx_call_show = False;
}

//------------------------------------------------------------------

  void
on_ftx_mesg_treeview_row_activated(
  GtkTreeView       *self,
  GtkTreePath       *path,
  GtkTreeViewColumn *column,
  gpointer           user_data )
{
  Ftx_Mesg_Row_Activated( self );
}

//------------------------------------------------------------------

  void
on_ftx_inqso_xplanet_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.dx_xplanet = True;
  else
  {
    // Kill xplanet and remove files
    if( ftx_rc.dx_xplanet )
      Kill_Xplanet(
          ftx_rc.xplanet_config_file,
          ftx_rc.xplanet_marker_file,
          ftx_rc.xplanet_arc_file );
    ftx_rc.dx_xplanet = False;
  }
}

//------------------------------------------------------------------

  void
on_ftx_band_xplanet_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.band_xplanet = True;
  else
  {
    // Kill xplanet and remove files
    if( ftx_rc.band_xplanet )
      Kill_Xplanet(
          ftx_rc.xplanet_config_file,
          ftx_rc.xplanet_marker_file,
          ftx_rc.xplanet_arc_file );
    ftx_rc.band_xplanet = False;
  }
}

//------------------------------------------------------------------

  void
on_ftx_colorize_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.colorize = True;
  else
    ftx_rc.colorize = False;
}

//------------------------------------------------------------------

  void
on_ftx_message_entry_activate(
    GtkEntry *entry,
    gpointer user_data )
{
#define FTX_MESG_SIZE   32
  gchar mesg[FTX_MESG_SIZE];

  // Capitalize messages
  Strlcpy( mesg, gtk_entry_get_text(entry), FTX_MESG_SIZE );
  for( uint8_t idx = 0; mesg[idx] != '\0'; idx++ )
    mesg[idx] = (gchar)( toupper(mesg[idx]) );
  gtk_entry_set_text( entry, (gchar *)mesg );
}

//------------------------------------------------------------------

  void
on_ftx_send_mesg_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  if( ftx_rc.messages_ready ) FTx_Send_Message( user_data );
}

//------------------------------------------------------------------

  void
on_ftx_send_cq_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  if( ftx_rc.send_cq_ready) FTx_Send_CQ();
}

//------------------------------------------------------------------

  void
on_new_cq_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  FTx_Create_CQ();
}

//------------------------------------------------------------------

  void
on_ftx_save_record_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  FTx_Save_QSO( &ftx_qso_record );
}

//------------------------------------------------------------------

  void
on_enable_tx_toggled(
    GtkToggleButton *togglebutton,
    gpointer    user_data )
{
  FTx_Enable_Tx( togglebutton );
}

//------------------------------------------------------------------

  void
on_select_cq_combo_changed(
  GtkComboBox *combo_box,
  gpointer user_data )
{
  ftx_rc.select_cq_idx = (uint8_t)gtk_combo_box_get_active( combo_box );
}

//------------------------------------------------------------------

  void
on_reply_cq_combo_changed(
  GtkComboBox *combo_box,
  gpointer user_data )
{
  ftx_rc.reply_cq_idx = (uint8_t)gtk_combo_box_get_active( combo_box );
}

//------------------------------------------------------------------

  void
on_auto_sequence_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.auto_sequence = True;
  else
    ftx_rc.auto_sequence = False;
}

//------------------------------------------------------------------

  void
on_auto_qso_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.auto_qso = True;
  else
    ftx_rc.auto_qso = False;
}

//------------------------------------------------------------------

  void
on_tx_even_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.tx_even = True;
  else
    ftx_rc.tx_even = False;
}

//------------------------------------------------------------------

  void
on_tx_frequency_value_changed(
  GtkSpinButton *spinbutton,
  gpointer user_data )
{
  ftx_rc.tx_frequency = (uint16_t)gtk_spin_button_get_value_as_int( spinbutton );
}

//------------------------------------------------------------------

  void
on_ftx_clear_cq_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  // Clear CQ message entry
  gtk_entry_set_text( GTK_ENTRY(ftx_gui.message_entry[FTX_CQ_ENTRY]), "" );

  // Set Send CQ label in greyed markup
  Set_Label_Markup( GTK_LABEL(ftx_gui.send_cq_label), MARKUP_GREY, " Send CQ " );
  ftx_rc.send_cq_ready = False;

  // Clear the pending/active message index
  if( CQ_MESSAGE ) ftx_rc.active_mesg_idx = FTX_NO_ACTIVE_MESG;
}

//------------------------------------------------------------------

  void
on_ftx_find_tx_freq_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  FTx_Find_Tx_Freq();
}

//------------------------------------------------------------------

  void
on_auto_save_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    ftx_rc.auto_save = True;
  else
    ftx_rc.auto_save = False;
}

//------------------------------------------------------------------

