/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef COMMON_UTILS_H
#define COMMON_UTILS_H   1

#include "common.h"
#include <gtk/gtk.h>
#include <semaphore.h>
#include <stdio.h>
#include <stddef.h>

//----------------------------------------------------------------------

/* utils.c */
int Read_Line(char *buff, FILE *pfile, const char *mesg);
void Strlcpy(char *dest, const char *src, size_t n);
void Strlcat(char *dest, const char *src, size_t n);
double Strtod(const char *nptr);
void Mem_Alloc(void **ptr, size_t req);
void Mem_Realloc(void **ptr, size_t req);
void Mem_Free(void **ptr);
BOOLEAN Open_File(FILE **fp, const char *fname, const char *mode);
void Close_File(FILE **fp);
void Fprintf_Error(FILE *fp, const char *filename);
void Colorize(guchar *pix, uint8_t pixel_val);
void Gtk_Builder(GtkBuilder **builder, gchar *file, gchar **object_ids);
GtkWidget *Builder_Get_Object(GtkBuilder *builder, gchar *name);
void Error_Dialog(gchar *mesg, gboolean hide_ok);
BOOLEAN Init_Semaphore(sem_t *semaphore, BOOLEAN init);
void Set_Label_Text(GtkLabel *label, const gchar *text);
void Set_Entry_Text(GtkEntry *entry, const gchar *text);
void Set_Icon(GtkImage *image, const gchar *name, GtkIconSize size);
void Set_Toggle_Btn(GtkToggleButton *button, gboolean flag);
BOOLEAN Pthread_Create(pthread_t *thread, const pthread_attr_t *attr, void *(*start_routine)(void *), void *arg, gchar *err_msg);
void Get_Iter_at_Offset(GtkTextBuffer *text_buffer, GtkTextIter *iter);
void Queue_Draw(GtkWidget *darea);
BOOLEAN Flush_Tx_Buffer(uint32_t buf_len);
void Set_Label_Markup(GtkLabel *label, uint8_t mkup, const char *text);

//----------------------------------------------------------------------

#endif

