/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"
#include "common.h"
#include "hermes2_rc.h"
#include "transceiver.h"
#include "../hpsdr/discovery.h"
#include "../hpsdr/pc_to_hw.h"
#include <gtk/gtk.h>
#include <semaphore.h>
#include <stdint.h>
#include <stdlib.h>

//----------------------------------------------------------------------

// Runtime config data
hermes2_rc_t hermes2_rc;

//----------------------------------------------------------------------

// An array of single-byte True or False control flags
BOOLEAN Flag[NUM_OF_FLAGS];

//----------------------------------------------------------------------

// Command Control and Audio IQ Data packet PC to Metis
Cmnd_Ctrl_Audio_IQ_Data_t Cmnd_Ctrl_Audio_IQ_Data;

//----------------------------------------------------------------------

// Radio Transceiver (DDC/DUC processing) object
Transceiver_t *Transceiver[MAX_RECEIVERS];

/* Pointers to the current I and Q float buffers in above */
double *demod_id_cpy = NULL, *demod_qd_cpy = NULL;
size_t demod_iq_buf_siz;

//----------------------------------------------------------------------

// Pointer to Modulator function
void (*Modulator)( void *data );

// Pointer to follow-up Modulator function
void (*Next_Modulator)( void *data );

//----------------------------------------------------------------------

// Device discovery variables
discovered_device_t Device[MAX_DEVICES];

//----------------------------------------------------------------------

// Send-Receive socket
int data_socket_fd = 0;

//----------------------------------------------------------------------

// Audio samples for digital modes (psk31, rtty, hell etc )
int16_t digimode_buffer[NUM_DIGIMODE_BUFFERS][DIGIMODE_BUFFER_SIZE];
uint8_t digi_buf_input = 0;

// Rx data transfer semaphore for digimodes
sem_t digimode_semaphore;

// Rx data transfer semaphore for RSID
sem_t rsid_semaphore;

// Synchronises sending samples packet to DUC
sem_t duc_send_semaphore;

//----------------------------------------------------------------------

// Indices and counts related to Transceiver objects
Indices_t Indices;

//----------------------------------------------------------------------

// Global window and dialog widgets
hermes2_gui_t hermes2_gui;

//----------------------------------------------------------------------

// DDC Audio Samples ring buffer
audio_ring_buff_t audio_ring_buff;

//----------------------------------------------------------------------

/* Buffer used by digimodes to
 * prepare samples for the DUC */
xmit_buffer_t xmit_buffer;

//----------------------------------------------------------------------

/* Socket addresses for the different
 * packages to be sendto() or recvfrom() */
sock_addr_t sock_addr;

//----------------------------------------------------------------------

