/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef COMMON_IFFT_H
#define COMMON_IFFT_H   1

#include "common.h"
#include <stdint.h>

//----------------------------------------------------------------------

// Structure with data for the iFFT function
typedef struct _IFFT_DATA
{
  // Input/Output data array
  int16_t *ifft_data, *ifft_bins;

  uint16_t
    data_len,    // Length of above array
    ifft_width,  // Width (number of points) of FFT
    ifft_stride, // Number of DSP samples after which one is saved for FFT
    *bin_ave,    // Average value of FFT bins
    ifft_order;  // iFFT Order (log2 N)

  int16_t *Sinewave;  // Sine wave table
  BOOLEAN ifft_init;  // iFFT initialized flag

} ifft_data_t;

//----------------------------------------------------------------------

/* ifft.c */
BOOLEAN Initialize_iFFT(ifft_data_t *ifft_data);
void iFFT_Real(ifft_data_t *ifft_data);
BOOLEAN iFFT_Data(int16_t sample, ifft_data_t *ifft_data);
uint8_t iFFT_Bin_Value(ifft_data_t *ifft_data, uint16_t idx, uint8_t reset);
void Free_iFFT(ifft_data_t *ifft_data);

//----------------------------------------------------------------------

#endif

