/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef COMMON_RC_CONFIG_H
#define COMMON_RC_CONFIG_H   1

#include "common.h"
#include <gtk/gtk.h>
#include <stdint.h>

//----------------------------------------------------------------------

// Number of amateur bands covered by the Transceiver
#define NUMBER_OF_BANDS   11

// Flags to control the saving of the config file
#define FROM_CONFIG    True
#define FROM_HERMES    False

//----------------------------------------------------------------------

// Runtime config data
typedef struct _HERMES2_RC
{
  char hermes2_glade[FILE_NAME_SIZE];  // Glade file path

  uint32_t
    ddc_buffer_length,  // DDC TRx samples buffer length
    ddc_sample_rate;    // DDC Sample Rate S/s

  // Cut off frequency of Tx mic low pass filter
  uint16_t mic_lpf_cutoff;

  uint8_t
    number_of_devices,  // Number of HPSDR devices discovered
    rx_antenna,         // Receiver antenna in use
    num_of_receivers,   // Number of receiver "slices"
    ptt_hang_time,      // PTT Hang time in mS, default 15mS
    ddc_mic_rate_ratio, // Ratio of Microphone to DDC sample rate
    rf_delay,           // A short delay in uS before RF is generated
    tx_buf_latency;     // TX Buffer latency in mS, default 20mS

  gint
    ddc_buffer_idx,     // DDC TRx Samples Buffer Combobox index
    sample_rate_idx,    // Sample Rate combobox index
    device_index;       // Selected Device in Device Combobox

  uint16_t
    cw_hang_time,  // CW Hang time in mS, default 500 mS
    beep_volume;   // Beep sound volume

  double
    tx_power_limit,  // Upper limit of Tx power output, set by slider
    tx_tune_power;   // Transmitter Power on Tune as % of max power

  uint32_t
    rx_bands[NUMBER_OF_BANDS],  // Saved frequency per Rx band
    tx_bands[NUMBER_OF_BANDS];  // Saved frequency per Tx band

  uint8_t
    rx_modes[NUMBER_OF_BANDS],  // Saved mode per Rx band
    tx_modes[NUMBER_OF_BANDS];  // Saved mode per Tx band

  // Frequency correction factor
  double device_freq_error;

  // Sound Card PCM device and HWCTL device names
  char pcm_device[32], hwctl_device[32];

  // Capture Source and Capture Volume control device names
  char capture_src[32], capture_vol[32];

  // Capture Channel ID (Front/Rear Mic etc) and Volume Level
  int capture_chan, capture_level;

  // Sound Channel to use (Left = 0, Right = 1)
  uint8_t use_snd_chan;

  // Enable local (PC sound card) Audio
  BOOLEAN sound_pc_local;

  // *** Save/Restore GUI Configuration data ***
  gint
    hermes2_window_x,
    hermes2_window_y,
    bookmarks_window_width,
    bookmarks_window_height,
    bookmarks_window_x,
    bookmarks_window_y,
    time_window_x,
    time_window_y;

  // GTK+ Monitor widgets data
  uint16_t
    spectrum_width,       // Width of Monitor drawingarea
    spectrum_height,      // Height of Monitor drawingarea
    waterfall_rowstride,  // Waterfall pixbuff Rowstride
    waterfall_n_channels, // Watefall pixbuff number of channels
    waterfall_width,      // Watefall pixbuff width
    waterfall_height,     // Watefall pixbuff height
    scope_clear_height,   // Signal Scope clear height above freq scale
    scope_width,          // Signal Scope width
    scope_height;         // Signal Scope height

  // Send a Message in Morse code
  char morse_mesg[32];

  // Thread contexts for guest modes transmit or receive threads
  pthread_t guest_rx_thread, guest_tx_thread;

} hermes2_rc_t;

//----------------------------------------------------------------------

/* hermes2_rc.c */
gboolean Verify_Config(gpointer data);
void Create_Hermes2_Config(void);
void Restore_TCVR_GUI(void);
void Restore_Hermes2_GUI(void);
gboolean Read_Config(gpointer data);
void Get_GUI_Geometry(void);
BOOLEAN Save_Hermes2_Config(BOOLEAN from_config);
BOOLEAN Save_Default_Config(void);

//----------------------------------------------------------------------

#endif

