/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef COMMON_FILTERS_H
#define COMMON_FILTERS_H   1

#include "transceiver.h"

//----------------------------------------------------------------------

/* Low Pass Filter parameters for CW filters.
 * The number of poles _must_be_even_ */
#define RX_CW_FILTER_POLES     6
#define RX_CW_FILTER_RIPPLE    1.0

//----------------------------------------------------------------------

/* filters.c */
void Deinit_Chebyshev_Filter(filter_data_t *filter_data);
void DSP_Filter(filter_data_t *filter_data);
void DSP_Filter2(filter_data_t *filter_data);
void Init_Roofing_Filter(Transceiver_t *TRx);

//----------------------------------------------------------------------

#endif

