/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef COMMON_COMMON_H
#define COMMON_COMMON_H   1

#include <stdint.h>

//----------------------------------------------------------------------

#ifndef cmplx
  #define cmplx(r, i) ((r)+(double)I*(i))
#endif

#ifndef norm
  #define norm(a, b) ( (a*a) + (b*b) )
#endif

//----------------------------------------------------------------------

// Internal on-off-reset flags
#ifndef True
  #define True    1
#endif
#ifndef False
  #define False   0
#endif

// Boolean type
#define BOOLEAN  uint8_t

//----------------------------------------------------------------------

// Return values and Flags. SUCCESS must be 0
enum
{
  SUCCESS = 0,
  ERROR,
  FAILURE,
  RUNNING,
  FINISHED,
  RESET
};

//----------------------------------------------------------------------

// Hide error dialog OK button
#define HIDE_OK     TRUE
#define SHOW_OK     FALSE

//----------------------------------------------------------------------

// Rx or Tx flags
#define RX_FLAG     True
#define TX_FLAG     False

//----------------------------------------------------------------------

// MOX control flags
#define MOX_ON     True
#define MOX_OFF    False

//----------------------------------------------------------------------

// Hide or show some button box widgets
#define SHOW_BUTTON_BOX    0x01
#define HIDE_BUTTON_BOX    0x02
#define SHOW_CLOSE_BUTTON  0x04
#define HIDE_CLOSE_BUTTON  0x08
#define FREE_DIALOG        0x10

//----------------------------------------------------------------------

// Should have been in math.h
#ifndef M_2PI
  #define M_2PI     6.28318530718
#endif

//----------------------------------------------------------------------

// Port definitions from host to hardware
#define DISCOVERY_PORT    1024

//----------------------------------------------------------------------

// The weight of binary bits in a uint8_t
#define BIT_0   0x01
#define BIT_1   0x02
#define BIT_2   0x04
#define BIT_3   0x08
#define BIT_4   0x10
#define BIT_5   0x20
#define BIT_6   0x40
#define BIT_7   0x80

// Clear C&C C0
#define CLEAR_C0    0x81

//----------------------------------------------------------------------

// Bookmarks treeview up-down selection
#define TREEVIEW_UP       1
#define TREEVIEW_DOWN     2

//----------------------------------------------------------------------

/**** Some common defines ***/

// Maximum size of file names
#define FILE_NAME_SIZE     128

// Length of xplanet command string
#define XPLANET_CMND_SIZE  255

/* Size of buffers for reading lines from
 * config files using the Read_Line() util */
#define READ_LINE_BUF_SIZE   81

// Length of char arrays (strings) for error messages etc
#define MESG_STRING_SIZE   255

// Number of recognizable tags in prepared Macros
#define NUM_OF_TAGS     13

// phi ring buffer length
#define PHI_BUF_LENGTH   5

// Receive and Transmit status indicators
#define RECV_OFF  _("RECEIVE OFF")
#define RECV_ON   _("<span background=\"green\" foreground=\"white\">  RECEIVE ON  </span>")

#define XMIT_OFF  _("TRANSMIT OFF")
#define XMIT_ON   _("<span background=\"red\" foreground=\"white\">  TRANSMIT ON  </span>")

// Clearance in pix of scope upper and lower sides
#define SCOPE_CLEAR     2

// For string buffers replacing tags with Macros
#define TAG_STRING_SIZE  13
#define TAG_REPLACE_SIZE 22

// Table of tag strings
#define TAG_TABLE \
{ \
  "own-call", "own-name" , "own-qth" , \
  "own-loc" , "own-rst"  , "rem-call", \
  "rem-name", "rem-qth"  , "rem-loc" , \
  "rem-rst" , "date-time", "op-freq" , \
  "app-version" \
}

//----------------------------------------------------------------------

// Some character definitions
#define HT   0x09  // Horizontal Tab
#define BS   0x08  // Back Space
#define CR   0x0d  // Carriage Return
#define LF   0x0a  // Line Feed

// No character decoded yet
#define NO_CHARACTER    0x80

//----------------------------------------------------------------------

/* Maximum DUC sample value in use. Must only be used
 * with I or Q, with the other sample set to zero */
#define DUC_SAMPLE_MAX  0x7FFF

// Maximum DUC sample value when applied to both I and Q
#define IQ_SAMPLE_MAX  0x5A80  // ~ DUC_SAMPLE_MAX * cos(45)

// Maximum level of Microphone samples in use
#define MIC_SAMPLE_MAX  0x7FFF

//----------------------------------------------------------------------

// Background and foreground colors for "scope" displays
#define SCOPE_BACKGND      0.00, 0.25, 0.00
#define SCOPE_FOREGND      0.00, 1.00, 0.00

//----------------------------------------------------------------------

  // Some markup strings for labels
#define MKUP_TEXT    "%s"
#define MKUP_GREEN   "<span background=\"green\"  foreground=\"white\"> %s </span>"
#define MKUP_RED     "<span background=\"red\"    foreground=\"white\"> %s </span>"
#define MKUP_ORANGE  "<span background=\"orange\" foreground=\"black\"> %s </span>"
#define MKUP_CYAN    "<span background=\"cyan\"   foreground=\"black\"> %s </span>"
#define MKUP_GREY    "<span background=\"grey\"   foreground=\"black\"> %s </span>"

enum _MARKUP_INDEX
{
  MARKUP_TEXT,
  MARKUP_GREEN,
  MARKUP_RED,
  MARKUP_ORANGE,
  MARKUP_CYAN,
  MARKUP_GREY,
};

#define HERMES2_MARKUP_SIZE   128

//----------------------------------------------------------------------

// International Amateur Radio Bands
#define LO_160   1800000
#define HI_160   2000000
#define LO_80    3500000
#define HI_80    4000000
#define LO_60    5275000
#define HI_60    5450000
#define LO_40    7000000
#define HI_40    7300000
#define LO_30   10100000
#define HI_30   10150000
#define LO_20   14000000
#define HI_20   14350000
#define LO_17   18068000
#define HI_17   18168000
#define LO_15   21000000
#define HI_15   21450000
#define LO_12   24890000
#define HI_12   24990000
#define LO_10   28000000
#define HI_10   29700000

// Bands Combobox Index
enum _BANDS_IDX
{
  IDX_GEN = 0,
  IDX_160,
  IDX_80,
  IDX_60,
  IDX_40,
  IDX_30,
  IDX_20,
  IDX_17,
  IDX_15,
  IDX_12,
  IDX_10
};

//----------------------------------------------------------------------

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  define Q_(String) g_strip_context ((String), gettext (String))
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define Q_(String) g_strip_context ((String), (String))
#  define N_(String) (String)
#endif

//----------------------------------------------------------------------

#endif

