/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef COMMON_CFFT_H
#define COMMON_CFFT_H   1

#include "transceiver.h"
#include "common.h"
#include <stdint.h>

//----------------------------------------------------------------------

/* cfft.c */
void Initialize_FFT(spectrum_data_t *spectrum_data, uint16_t spectrum_width, uint16_t input_length, BOOLEAN forward);
void Deinit_FFT(spectrum_data_t *spectrum_data);
void cFFT(uint16_t fft_in_length, uint16_t fft_order, double *fft_in_i, double *fft_in_q);

//----------------------------------------------------------------------

#endif

