/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_SPECTRUM_H
#define HERMES2_SPECTRUM_H   1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

//----------------------------------------------------------------------

/* Width of FFT Spectrum Displays (number of FFT output bins)
 * as well as length of input buffers for Complex FFT */
#define SPECTRUM_WIDTH   1024
#define SPECTRUM_HEIGHT  300

//----------------------------------------------------------------------

/* spectrum.c */
void Free_Scope_Points(uint8_t idx);
void Hermes2_Spectrum_Draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void Hermes2_Spectrum_Size_Alloc(GtkWidget *widget);
void Hermes2_Tune_to_Monitor(double pos_x, gpointer user_data);

//----------------------------------------------------------------------

#endif

