/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_SOUND_H
#define HERMES2_SOUND_H   1

#include "../common/common.h"
#include <stdint.h>
#include <alsa/asoundlib.h>

//----------------------------------------------------------------------

#define SND_DSP_RATE      48000  // Sound Card DSP Rate - samples/sec
#define SND_NUM_CHANNELS  2      // 1 = MONO, 2 = STEREO <- only accepted

//----------------------------------------------------------------------

/* sound.c */
uint8_t Open_PCSound(void);
uint8_t DSP_Write(short *buffer, uint32_t buf_len);
void Close_PCSound(void);
uint8_t Open_Capture(void);
uint8_t Signal_Sample(short *sample_val);
void Close_Capture(void);
uint8_t Open_Mixer(snd_mixer_t **handle, char *mesg);
uint8_t Set_Capture_Level(int level, char *mesg);
void Close_Mixer(void);

//----------------------------------------------------------------------

#endif

