/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_PROCESS_H
#define HERMES2_PROCESS_H   1

#include "../common/transceiver.h"

//----------------------------------------------------------------------

// Pointer to Time Station receiver function
extern void (*Receive_Time_Station)( Transceiver_t *TRx );

/* process.c */
void Hermes2_Run(Transceiver_t *TRx);
void Hermes2_Stop(void);
void *Sound_Write_Async(void *arg);
void *Paint_Waterfall(void *data);

//----------------------------------------------------------------------

#endif

