/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_MODULATE_H
#define HERMES2_MODULATE_H   1

#include "../common/common.h"
#include <stdint.h>

//----------------------------------------------------------------------

/* modulate.c */
void Clear_DUC(void);
BOOLEAN Generate_CW(BOOLEAN up_flag);
void Modulate_CW(void *data);
void Modulate_SSB(void *data);
void Modulate_AM(void *data);
void Modulate_FM(void *data);
void Morse_Transmit(void *data);
void DUC_Buffer_Transmit(void *data);
void Free_Modulator_Buffers(void);

//----------------------------------------------------------------------

#endif

