/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HERMES2_DISPLAY_H
#define HERMES2_DISPLAY_H   1

#include "../common/transceiver.h"
#include <gtk/gtk.h>
#include <stdint.h>

//----------------------------------------------------------------------

// Markups for frequency displays
#define POINTER_ENTER_MARKUP \
  "<span background=\"green\" foreground=\"white\" size=\"x-large\">%1u</span>"
#define POINTER_LEAVE_MARKUP "<span size=\"x-large\">%1u</span>"

//----------------------------------------------------------------------

/* Pointer to the center frequency "spin button"
 * label that has the pointer enter or leave it */
extern GtkLabel *pointer_cross_label;

//----------------------------------------------------------------------

/* display.c */
void Set_Rx_Band(Transceiver_t *TRx, uint32_t freq);
void Display_Frequency_Spin_Dial(Transceiver_t *TRx, GtkLabel *label, int32_t data);
void Update_Spin_Dial(Transceiver_t *TRx, BOOLEAN rx_flag);
void Append_Sample_Rates(GtkWidget *rate_combobox);
void Append_Device_Names(GtkWidget *combobox);
void Append_BWidth_Weaver(Transceiver_t *TRx);
gboolean Hermes2_Display_S_meter(gpointer data);
void Hermes2_Display_Mode(Transceiver_t *TRx, uint8_t mode, BOOLEAN rx_flag);
void Hpsdr_ADAGC_Smeter(Transceiver_t *TRx);
gboolean Hermes2_Frequency_Status(gpointer data);
void RSID_Mode(const char *mode, uint32_t freq);
gboolean RSID_Status(gpointer data);

//----------------------------------------------------------------------

#endif

